/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

final class TinySetIndexing {
    private int chainStart;
    private int chainEnd;

    TinySetIndexing() {
    }

    public int getChainStart(HashedItem fpaux, long[] chainIndex, long[] isLastIndex) {
        int requiredChainNumber = this.rank(chainIndex[fpaux.set], fpaux.chainId);
        int currentChainNumber = this.rank(isLastIndex[fpaux.set], requiredChainNumber);
        int currentOffset = requiredChainNumber;
        long tempIsLastIndex = isLastIndex[fpaux.set] >>> requiredChainNumber;
        while (currentChainNumber < requiredChainNumber) {
            currentChainNumber += (int)tempIsLastIndex & 1;
            ++currentOffset;
            tempIsLastIndex >>>= 1;
        }
        return currentOffset;
    }

    public int rank(long index, int bitNum) {
        return Long.bitCount(index & (-1L << bitNum ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @CanIgnoreReturnValue
    public int getChain(HashedItem fpaux, long[] chainIndex, long[] isLastIndex) {
        int requiredChainNumber = this.rank(chainIndex[fpaux.set], fpaux.chainId);
        int currentChainNumber = this.rank(isLastIndex[fpaux.set], requiredChainNumber);
        int currentOffset = requiredChainNumber;
        long tempisLastIndex = isLastIndex[fpaux.set] >>> requiredChainNumber;
        while (currentChainNumber < requiredChainNumber) {
            currentChainNumber += (int)tempisLastIndex & 1;
            ++currentOffset;
            tempisLastIndex >>>= 1;
        }
        this.setChainStart(currentOffset);
        while ((tempisLastIndex & 1L) == 0L) {
            ++currentOffset;
            tempisLastIndex >>>= 1;
        }
        this.setChainEnd(currentOffset);
        return currentOffset;
    }

    public int getChainAtOffset(HashedItem fpaux, long[] chainIndex, long[] isLastIndex, int offset) {
        int nonEmptyChainsToSee = this.rank(isLastIndex[fpaux.set], offset);
        int nonEmptyChainSeen = this.rank(chainIndex[fpaux.set], nonEmptyChainsToSee);
        int i = nonEmptyChainsToSee;
        while (i <= 64) {
            if (this.chainExist(chainIndex[fpaux.set], i) && nonEmptyChainSeen == nonEmptyChainsToSee) {
                return i;
            }
            nonEmptyChainSeen = this.rank(chainIndex[fpaux.set], i += Math.max(1, nonEmptyChainsToSee - nonEmptyChainSeen));
        }
        throw new IllegalStateException("Cannot choose victim!");
    }

    public boolean chainExist(long chainIndex, int chainId) {
        return (chainIndex | 1L << chainId) == chainIndex;
    }

    public int addItem(HashedItem fpaux, long[] chainIndex, long[] lastIndex) {
        int offset = this.getChainStart(fpaux, chainIndex, lastIndex);
        long mask = 1L << fpaux.chainId;
        lastIndex[fpaux.set] = TinySetIndexing.extendZero(lastIndex[fpaux.set], offset);
        if ((mask | chainIndex[fpaux.set]) != chainIndex[fpaux.set]) {
            int n = fpaux.set;
            chainIndex[n] = chainIndex[n] | mask;
            int n2 = fpaux.set;
            lastIndex[n2] = lastIndex[n2] | 1L << offset;
        }
        return offset;
    }

    private static long extendZero(long isLastIndex, int offset) {
        long constantPartMask = (1L << offset) - 1L;
        return isLastIndex & constantPartMask | isLastIndex << 1 & (constantPartMask ^ 0xFFFFFFFFFFFFFFFFL) & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long shrinkOffset(long isLastIndex, int offset) {
        long conMask = (1L << offset) - 1L;
        return isLastIndex & conMask | ((conMask ^ 0xFFFFFFFFFFFFFFFFL) & isLastIndex) >>> 1;
    }

    public void removeItem(HashedItem fpaux, long[] chainIndex, long[] isLastIndex) {
        int chainStart = this.getChainStart(fpaux, chainIndex, isLastIndex);
        chainIndex[fpaux.set] = (isLastIndex[fpaux.set] & 1L << chainStart) == 0L ? chainIndex[fpaux.set] : chainIndex[fpaux.set] & (1L << fpaux.chainId ^ 0xFFFFFFFFFFFFFFFFL);
        isLastIndex[fpaux.set] = TinySetIndexing.shrinkOffset(isLastIndex[fpaux.set], chainStart);
    }

    public int getChainStart() {
        return this.chainStart;
    }

    public void setChainStart(int chainStart) {
        this.chainStart = chainStart;
    }

    public int getChainEnd() {
        return this.chainEnd;
    }

    public void setChainEnd(int chainEnd) {
        this.chainEnd = chainEnd;
    }
}

