/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.EvictionPolicy;
import com.trivago.triava.tcache.TCacheFactory;
import com.trivago.triava.tcache.statistics.TCacheStatistics;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="product.TCache")
public final class TCachePolicy
implements Policy {
    private final Cache<Long, Boolean> cache;
    private final PolicyStats policyStats;
    private final TCacheFactory factory;

    public TCachePolicy(TCacheSettings settings, Eviction policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", new Object[]{policy});
        this.factory = new TCacheFactory();
        this.cache = this.factory.builder().setMaxElements(Math.toIntExact(settings.maximumSize())).setEvictionPolicy(policy.type).setStatistics(true).build();
    }

    public static Set<Policy> policies(Config config) {
        TCacheSettings settings = new TCacheSettings(config);
        return settings.policy().stream().map(policy -> new TCachePolicy(settings, (Eviction)((Object)policy))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(AccessEvent event) {
        Long key = event.longKey();
        Boolean value = (Boolean)this.cache.get((Object)key);
        if (value == null) {
            this.policyStats.recordMiss();
            this.cache.put((Object)key, (Object)Boolean.TRUE);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        TCacheStatistics stats = this.cache.statistics();
        this.factory.close();
        this.policyStats.addEvictions(stats.getEvictionCount());
        Preconditions.checkState((this.policyStats.hitCount() == stats.getHitCount() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == stats.getMissCount() ? 1 : 0) != 0);
    }

    public static final class TCacheSettings
    extends BasicSettings {
        public TCacheSettings(Config config) {
            super(config);
        }

        public ImmutableSet<Eviction> policy() {
            return (ImmutableSet)this.config().getStringList("tcache.policy").stream().map(policy -> (Eviction)((Object)((Object)Enums.getIfPresent(Eviction.class, (String)policy.toUpperCase(Locale.US)).toJavaUtil().orElseThrow(() -> new IllegalArgumentException("Unknown policy: " + policy))))).collect(Sets.toImmutableEnumSet());
        }
    }

    public static enum Eviction {
        LRU(EvictionPolicy.LRU),
        LFU(EvictionPolicy.LFU);

        final EvictionPolicy type;

        private Eviction(EvictionPolicy type) {
            this.type = type;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

