/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="irr.HillClimberFrd")
public final class HillClimberFrdPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final Node headFilter;
    final Node headMain;
    int maximumMainResidentSize;
    int maximumFilterSize;
    final int maximumSize;
    int residentSize;
    int residentFilter;
    int residentMain;
    private final int pivot;
    private int sample;
    private final int sampleSize;
    private int hitsInSample;
    private int missesInSample;
    private double previousHitRate;
    private final double tolerance;
    private boolean increaseWindow;

    public HillClimberFrdPolicy(Config config) {
        FrdSettings settings = new FrdSettings(config);
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maximumMainResidentSize = (int)((double)this.maximumSize * settings.percentMain());
        this.maximumFilterSize = this.maximumSize - this.maximumMainResidentSize;
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.headFilter = new Node();
        this.headMain = new Node();
        this.pivot = (int)(0.05 * (double)this.maximumSize);
        this.sampleSize = 10 * this.maximumSize;
        this.tolerance = 0.0;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        this.adapt();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            node = new Node(key);
            this.data.put(key, (Object)node);
            this.onMiss(node);
        } else if (node.status == Status.FILTER) {
            this.onFilterHit(node);
        } else if (node.status == Status.MAIN) {
            this.onMainHit(node);
        } else if (node.status == Status.NON_RESIDENT) {
            if (this.residentMain < this.maximumMainResidentSize) {
                Preconditions.checkState((this.residentFilter > this.maximumFilterSize ? 1 : 0) != 0);
                this.adaptFilterToMain(node);
            } else {
                this.onNonResidentHit(node);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void adapt() {
        if (this.sample >= this.sampleSize) {
            double hitRate = 100.0 * (double)this.hitsInSample / (double)(this.hitsInSample + this.missesInSample);
            if (!Double.isNaN(hitRate) && !Double.isInfinite(hitRate) && this.previousHitRate != 0.0) {
                if (hitRate < this.previousHitRate + this.tolerance) {
                    boolean bl = this.increaseWindow = !this.increaseWindow;
                }
                this.maximumFilterSize = this.increaseWindow ? (this.maximumFilterSize += this.pivot) : (this.maximumFilterSize -= this.pivot);
                if (this.maximumFilterSize <= 0) {
                    this.maximumFilterSize = 1;
                }
                if (this.maximumFilterSize >= this.maximumSize) {
                    this.maximumFilterSize = this.maximumSize - 1;
                }
                this.maximumMainResidentSize = this.maximumSize - this.maximumFilterSize;
            }
            this.previousHitRate = hitRate;
            this.missesInSample = 0;
            this.hitsInSample = 0;
            this.sample = 0;
        }
    }

    private void onMiss(Node node) {
        this.policyStats.recordMiss();
        ++this.missesInSample;
        ++this.sample;
        if (this.residentSize < this.maximumMainResidentSize) {
            HillClimberFrdPolicy.onMainWarmupMiss(node);
            ++this.residentSize;
            ++this.residentMain;
        } else if (this.residentSize < this.maximumSize) {
            HillClimberFrdPolicy.onFilterWarmupMiss(node);
            ++this.residentSize;
            ++this.residentFilter;
        } else if (this.residentFilter < this.maximumFilterSize) {
            this.adaptMainToFilter(node);
        } else {
            this.onFullMiss(node);
        }
    }

    private void adaptMainToFilter(Node node) {
        this.policyStats.recordEviction();
        this.pruneStack();
        Node victim = Objects.requireNonNull(this.headMain.prevMain);
        victim.removeFrom(StackType.MAIN);
        this.data.remove(victim.key);
        this.pruneStack();
        --this.residentMain;
        node.moveToTop(StackType.FILTER);
        node.moveToTop(StackType.MAIN);
        node.status = Status.FILTER;
        ++this.residentFilter;
    }

    private void adaptFilterToMain(Node node) {
        this.policyStats.recordEviction();
        this.policyStats.recordMiss();
        ++this.missesInSample;
        ++this.sample;
        Node victim = Objects.requireNonNull(this.headFilter.prevFilter);
        victim.removeFrom(StackType.FILTER);
        if (victim.isInMain) {
            victim.status = Status.NON_RESIDENT;
        } else {
            this.data.remove(victim.key);
        }
        --this.residentFilter;
        node.moveToTop(StackType.MAIN);
        node.status = Status.MAIN;
        this.data.put(node.key, (Object)node);
        ++this.residentMain;
    }

    private static void onMainWarmupMiss(Node node) {
        node.moveToTop(StackType.MAIN);
        node.status = Status.MAIN;
    }

    private static void onFilterWarmupMiss(Node node) {
        node.moveToTop(StackType.FILTER);
        node.status = Status.FILTER;
    }

    private void onFullMiss(Node node) {
        this.policyStats.recordEviction();
        Node victim = Objects.requireNonNull(this.headFilter.prevFilter);
        victim.removeFrom(StackType.FILTER);
        if (victim.isInMain) {
            victim.status = Status.NON_RESIDENT;
        } else {
            this.data.remove(victim.key);
        }
        node.moveToTop(StackType.FILTER);
        node.moveToTop(StackType.MAIN);
        node.status = Status.FILTER;
    }

    private void onFilterHit(Node node) {
        this.policyStats.recordHit();
        ++this.hitsInSample;
        ++this.sample;
        node.moveToTop(StackType.FILTER);
        node.moveToTop(StackType.MAIN);
    }

    private void onMainHit(Node node) {
        this.policyStats.recordHit();
        ++this.hitsInSample;
        ++this.sample;
        boolean wasBottom = this.headMain.prevMain == node;
        node.moveToTop(StackType.MAIN);
        if (wasBottom) {
            this.pruneStack();
        }
    }

    private void pruneStack() {
        Node bottom;
        while ((bottom = Objects.requireNonNull(this.headMain.prevMain)) != this.headMain && bottom.status != Status.MAIN) {
            if (bottom.status == Status.FILTER) {
                this.policyStats.recordOperation();
                bottom.removeFrom(StackType.MAIN);
                continue;
            }
            if (bottom.status != Status.NON_RESIDENT) continue;
            this.policyStats.recordOperation();
            bottom.removeFrom(StackType.MAIN);
            this.data.remove(bottom.key);
        }
    }

    private void onNonResidentHit(Node node) {
        this.policyStats.recordEviction();
        this.policyStats.recordMiss();
        ++this.missesInSample;
        ++this.sample;
        this.pruneStack();
        Node victim = Objects.requireNonNull(this.headMain.prevMain);
        victim.removeFrom(StackType.MAIN);
        this.data.remove(victim.key);
        this.pruneStack();
        node.moveToTop(StackType.MAIN);
        node.status = Status.MAIN;
        this.data.put(node.key, (Object)node);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        long mainSize;
        long filterSize = this.data.values().stream().filter(node -> node.status == Status.FILTER).count();
        Preconditions.checkState((filterSize + (mainSize = this.data.values().stream().filter(node -> node.status == Status.MAIN).count()) <= (long)this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.residentFilter == filterSize ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.residentMain == mainSize ? 1 : 0) != 0);
    }

    static final class FrdSettings
    extends BasicSettings {
        public FrdSettings(Config config) {
            super(config);
        }

        public double percentMain() {
            return this.config().getDouble("frd.percent-main");
        }
    }

    final class Node {
        final long key;
        @Nullable Node prevFilter;
        @Nullable Node nextFilter;
        @Nullable Node prevMain;
        @Nullable Node nextMain;
        @Nullable Status status;
        boolean isInFilter;
        boolean isInMain;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prevMain = this.nextMain = this;
            this.prevFilter = this.nextFilter = this;
        }

        Node(long key) {
            this.key = key;
        }

        public boolean isInStack(StackType stackType) {
            if (stackType == StackType.FILTER) {
                return this.isInFilter;
            }
            if (stackType == StackType.MAIN) {
                return this.isInMain;
            }
            throw new IllegalArgumentException();
        }

        public void moveToTop(StackType stackType) {
            if (this.isInStack(stackType)) {
                this.removeFrom(stackType);
            }
            switch (stackType.ordinal()) {
                case 0: {
                    Node next = Objects.requireNonNull(HillClimberFrdPolicy.this.headFilter.nextFilter);
                    HillClimberFrdPolicy.this.headFilter.nextFilter = this;
                    next.prevFilter = this;
                    this.nextFilter = next;
                    this.prevFilter = HillClimberFrdPolicy.this.headFilter;
                    this.isInFilter = true;
                    break;
                }
                case 1: {
                    Node next = Objects.requireNonNull(HillClimberFrdPolicy.this.headMain.nextMain);
                    HillClimberFrdPolicy.this.headMain.nextMain = this;
                    next.prevMain = this;
                    this.nextMain = next;
                    this.prevMain = HillClimberFrdPolicy.this.headMain;
                    this.isInMain = true;
                }
            }
        }

        public void removeFrom(StackType stackType) {
            Preconditions.checkState((boolean)this.isInStack(stackType));
            switch (stackType.ordinal()) {
                case 0: {
                    Objects.requireNonNull(this.prevFilter);
                    Objects.requireNonNull(this.nextFilter);
                    this.prevFilter.nextFilter = this.nextFilter;
                    this.nextFilter.prevFilter = this.prevFilter;
                    this.nextFilter = null;
                    this.prevFilter = null;
                    this.isInFilter = false;
                    break;
                }
                case 1: {
                    Objects.requireNonNull(this.prevMain);
                    Objects.requireNonNull(this.nextMain);
                    this.prevMain.nextMain = this.nextMain;
                    this.nextMain.prevMain = this.prevMain;
                    this.nextMain = null;
                    this.prevMain = null;
                    this.isInMain = false;
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.status).toString();
        }
    }

    static enum Status {
        NON_RESIDENT,
        FILTER,
        MAIN;

    }

    static enum StackType {
        FILTER,
        MAIN;

    }
}

