/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.two_queue;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

@Policy.PolicySpec(name="two-queue.Qdlp")
public final class QdlpPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final Node headGhost;
    final Node headFifo;
    final Node headMain;
    final int mainMaximumEntryFrequency;
    final int moveToMainThreshold;
    final int maximumSize;
    final int maxGhost;
    final int maxFifo;
    int sizeGhost;
    int sizeFifo;
    int sizeMain;

    public QdlpPolicy(Config config) {
        QdlpSettings settings = new QdlpSettings(config);
        this.data = new Long2ObjectOpenHashMap();
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.headGhost = new Node();
        this.headFifo = new Node();
        this.headMain = new Node();
        this.moveToMainThreshold = settings.moveToMainThreshold();
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maxFifo = (int)((double)this.maximumSize * settings.percentFifo());
        this.maxGhost = (int)((double)this.maximumSize * settings.percentGhost());
        this.mainMaximumEntryFrequency = settings.mainMaximumEntryFrequency();
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
        } else if (node.type == QueueType.GHOST) {
            this.onGhostHit(node);
        } else {
            this.onHit(node);
        }
    }

    private void onHit(Node node) {
        if (node.type == QueueType.FIFO) {
            ++node.frequency;
        } else if (node.type == QueueType.MAIN) {
            node.frequency = Math.min(node.frequency + 1, this.mainMaximumEntryFrequency);
        }
        this.policyStats.recordHit();
    }

    private void onGhostHit(Node node) {
        this.policyStats.recordMiss();
        node.remove();
        --this.sizeGhost;
        node.appendToTail(this.headMain);
        node.type = QueueType.MAIN;
        ++this.sizeMain;
        this.evict();
    }

    private void onMiss(long key) {
        Node node = new Node(key);
        node.appendToTail(this.headFifo);
        node.type = QueueType.FIFO;
        this.policyStats.recordMiss();
        this.data.put(key, (Object)node);
        ++this.sizeFifo;
        this.evict();
        if (this.sizeFifo > this.maxFifo) {
            Node promoted = this.headFifo.next;
            promoted.remove();
            --this.sizeFifo;
            promoted.appendToTail(this.headMain);
            promoted.type = QueueType.MAIN;
            ++this.sizeMain;
        }
    }

    private void evict() {
        if (this.sizeFifo + this.sizeMain <= this.maximumSize) {
            return;
        }
        this.policyStats.recordEviction();
        if (this.maxFifo == 0 || this.sizeFifo == 0) {
            this.evictFromMain();
            return;
        }
        Node candidate = this.headFifo.next;
        int freq = candidate.frequency;
        candidate.frequency = 0;
        candidate.remove();
        --this.sizeFifo;
        if (freq >= this.moveToMainThreshold) {
            this.evictFromMain();
            candidate.appendToTail(this.headMain);
            candidate.type = QueueType.MAIN;
            ++this.sizeMain;
        } else {
            candidate.appendToTail(this.headGhost);
            candidate.type = QueueType.GHOST;
            candidate.frequency = 0;
            ++this.sizeGhost;
            if (this.sizeGhost > this.maxGhost) {
                Node ghost = this.headGhost.next;
                this.data.remove(ghost.key);
                ghost.remove();
                --this.sizeGhost;
            }
        }
    }

    private void evictFromMain() {
        while (true) {
            Node victim = this.headMain.next;
            if (victim.frequency == 0) {
                this.data.remove(victim.key);
                victim.remove();
                --this.sizeMain;
                break;
            }
            --victim.frequency;
            victim.moveToTail(this.headMain);
        }
    }

    @Override
    public void finished() {
        int maximum = this.maximumSize + this.maxGhost;
        Preconditions.checkState((this.data.size() <= maximum ? 1 : 0) != 0, (String)"%s > %s", (int)this.data.size(), (int)maximum);
        long ghosts = this.data.values().stream().filter(node -> node.type == QueueType.GHOST).count();
        Preconditions.checkState((ghosts == (long)this.sizeGhost ? 1 : 0) != 0, (String)"ghosts: %s != %s", (long)ghosts, (int)this.sizeGhost);
        Preconditions.checkState((ghosts <= (long)this.maxGhost ? 1 : 0) != 0, (String)"ghosts: %s > %s", (long)ghosts, (int)this.maxGhost);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class QdlpSettings
    extends BasicSettings {
        public QdlpSettings(Config config) {
            super(config);
        }

        public double percentFifo() {
            return this.config().getDouble("qdlp.percent-fifo");
        }

        public double percentGhost() {
            return this.config().getDouble("qdlp.percent-ghost");
        }

        public int moveToMainThreshold() {
            return this.config().getInt("qdlp.move-to-main-threshold");
        }

        public int mainMaximumEntryFrequency() {
            return this.config().getInt("qdlp.main-clock-maximum-frequency");
        }
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        QueueType type;
        int frequency;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
        }

        public void appendToTail(Node head) {
            Preconditions.checkState((this.prev == null ? 1 : 0) != 0);
            Preconditions.checkState((this.next == null ? 1 : 0) != 0);
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void moveToTail(Node head) {
            Preconditions.checkState((this.prev != null ? 1 : 0) != 0);
            Preconditions.checkState((this.next != null ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = head;
            this.prev = head.prev;
            head.prev = this;
            this.prev.next = this;
        }

        public void remove() {
            Preconditions.checkState((this.prev != null ? 1 : 0) != 0);
            Preconditions.checkState((this.next != null ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    static enum QueueType {
        FIFO,
        MAIN,
        GHOST;

    }
}

