/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.Simulator;
import com.github.benmanes.caffeine.cache.simulator.report.csv.CombinedCsvReport;
import com.github.benmanes.caffeine.cache.simulator.report.csv.PlotCsv;
import com.google.common.base.Stopwatch;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true)
public final class Simulate
implements Runnable {
    @CommandLine.Option(names={"--maximumSize"}, required=true, split=",", description={"The maximum sizes"}, preprocessor=LongPreprocessor.class)
    private SortedSet<Long> maximumSizes;
    @CommandLine.Option(names={"--metric"}, required=true, defaultValue="Hit Rate", description={"The metric being compared"})
    private String metric;
    @CommandLine.Option(names={"--title"}, description={"The chart's title"}, defaultValue="")
    private String title;
    @CommandLine.Option(names={"--theme"}, required=true, defaultValue="light", description={"The chart's theme"})
    private Theme theme;
    @CommandLine.Option(names={"--outputDir"}, required=true, description={"The destination directory"})
    private Path outputDir;

    @Override
    public void run() {
        String baseName = this.metric.toLowerCase(Locale.US).replace(' ', '_');
        TreeMap<Long, Path> reports = new TreeMap<Long, Path>();
        Iterator iterator = this.maximumSizes.iterator();
        while (iterator.hasNext()) {
            long maximumSize = (Long)iterator.next();
            Stopwatch stopwatch = Stopwatch.createStarted();
            Path report = this.simulate(baseName, maximumSize);
            reports.put(maximumSize, report);
            System.out.printf(Locale.US, "%,d: Executed in %s%n", maximumSize, stopwatch);
        }
        if (reports.size() == 1) {
            System.out.printf(Locale.US, "Did not generate a chart as only one data point%n", new Object[0]);
            System.out.printf(Locale.US, "Wrote report to %s%n", reports.values().iterator().next());
            return;
        }
        Path combinedReport = this.combineReports(baseName, reports);
        System.out.printf(Locale.US, "Wrote combined report to %s%n", combinedReport);
        Path chart = this.generateChart(baseName, combinedReport);
        System.out.printf(Locale.US, "Wrote chart to %s%n", chart);
    }

    private Path simulate(String baseName, long maximumSize) {
        Path report = this.outputDir.resolve(baseName + "_" + maximumSize + ".csv");
        Config config = ConfigFactory.parseMap(Map.of("caffeine.simulator.report.format", "csv", "caffeine.simulator.maximum-size", maximumSize, "caffeine.simulator.report.output", report.toString())).withFallback((ConfigMergeable)ConfigFactory.load());
        Simulator simulator = new Simulator(config);
        simulator.run();
        return report;
    }

    private Path combineReports(String baseName, SortedMap<Long, Path> inputFiles) {
        Path report = this.outputDir.resolve(baseName + ".csv");
        CombinedCsvReport combiner = new CombinedCsvReport(inputFiles, this.metric, report);
        combiner.run();
        return report;
    }

    private Path generateChart(String baseName, Path report) {
        Path chart = this.outputDir.resolve(baseName + ".png");
        PlotCsv plotter = new PlotCsv(report, chart, this.metric, this.title, this.theme.style);
        plotter.run();
        return chart;
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.WARNING);
        new CommandLine(Simulate.class).setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON)).setCommandName(Simulate.class.getSimpleName()).setCaseInsensitiveEnumValuesAllowed(true).execute(args);
    }

    private static final class LongPreprocessor
    implements CommandLine.IParameterPreprocessor {
        private LongPreprocessor() {
        }

        public boolean preprocess(Stack<String> args, CommandLine.Model.CommandSpec commandSpec, CommandLine.Model.ArgSpec argSpec, Map<String, Object> info) {
            args.replaceAll(arg -> arg.replace("_", ""));
            return false;
        }
    }

    private static enum Theme {
        light(PlotCsv.ChartStyle.light()),
        dark(PlotCsv.ChartStyle.dark());

        final PlotCsv.ChartStyle style;

        private Theme(PlotCsv.ChartStyle style) {
            this.style = style;
        }
    }
}

