/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.linked;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="linked.S4Lru")
public final class S4LruPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Admittor admittor;
    private final int maximumSize;
    private final Node[] headQ;
    private final int[] sizeQ;
    private final int levels;

    public S4LruPolicy(Admission admission, Config config) {
        S4LruSettings settings = new S4LruSettings(config);
        this.policyStats = new PolicyStats(admission.format(this.name()), new Object[0]);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.admittor = admission.from(config, this.policyStats);
        this.data = new Long2ObjectOpenHashMap();
        this.levels = settings.levels();
        this.headQ = new Node[this.levels];
        this.sizeQ = new int[this.levels];
        Arrays.setAll(this.headQ, Node::sentinel);
    }

    public static Set<Policy> policies(Config config) {
        BasicSettings settings = new BasicSettings(config);
        return settings.admission().stream().map(admission -> new S4LruPolicy((Admission)((Object)admission), config)).collect(Collectors.toSet());
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else {
            this.onHit(node);
            this.policyStats.recordHit();
        }
    }

    private void onHit(Node node) {
        node.remove();
        int n = node.level;
        this.sizeQ[n] = this.sizeQ[n] - 1;
        if (node.level < this.levels - 1) {
            ++node.level;
        }
        Node head = this.headQ[node.level];
        node.appendToTail(head);
        int n2 = node.level;
        this.sizeQ[n2] = this.sizeQ[n2] + 1;
        this.adjust();
    }

    private void onMiss(long key) {
        Node node = new Node(key);
        this.data.put(key, (Object)node);
        node.appendToTail(this.headQ[0]);
        this.sizeQ[0] = this.sizeQ[0] + 1;
        this.adjust();
        this.evict(node);
    }

    private void adjust() {
        int maxPerLevel = this.maximumSize / this.levels;
        for (int i = this.levels - 1; i > 0; --i) {
            if (this.sizeQ[i] <= maxPerLevel) continue;
            Node demote = this.headQ[i].next;
            demote.remove();
            int n = i;
            this.sizeQ[n] = this.sizeQ[n] - 1;
            int n2 = demote.level = i - 1;
            this.sizeQ[n2] = this.sizeQ[n2] + 1;
            demote.appendToTail(this.headQ[demote.level]);
        }
    }

    private void evict(Node candidate) {
        if (this.data.size() > this.maximumSize) {
            this.policyStats.recordEviction();
            Node victim = this.headQ[0].next;
            boolean admit = this.admittor.admit(candidate.key, victim.key);
            if (admit) {
                this.evictEntry(victim);
                this.sizeQ[0] = this.sizeQ[0] - 1;
            } else {
                this.evictEntry(candidate);
                int n = candidate.level;
                this.sizeQ[n] = this.sizeQ[n] - 1;
            }
        }
    }

    private void evictEntry(Node node) {
        this.data.remove(node.key);
        node.remove();
    }

    @Override
    public void finished() {
        for (int i = 0; i < this.levels; ++i) {
            int level = i;
            long count = this.data.values().stream().filter(node -> node.level == level).count();
            Preconditions.checkState((count == (long)this.sizeQ[i] ? 1 : 0) != 0);
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class S4LruSettings
    extends BasicSettings {
        public S4LruSettings(Config config) {
            super(config);
        }

        public int levels() {
            return this.config().getInt("s4lru.levels");
        }
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        int level;

        Node(long key) {
            this.key = key;
        }

        static Node sentinel(int level) {
            Node node = new Node(Long.MIN_VALUE);
            node.level = level;
            node.prev = node;
            node.next = node;
            return node;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Preconditions.checkState((this.key != Long.MIN_VALUE ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("level", this.level).toString();
        }
    }
}

