/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.japi.function.Function;
import com.github.benmanes.caffeine.cache.simulator.Simulator;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class PolicyActor
extends AbstractBehavior<Command> {
    private final ActorRef<Simulator.Command> simulator;
    private final Policy policy;

    public PolicyActor(ActorContext<Command> context, ActorRef<Simulator.Command> simulator, Policy policy) {
        super(context);
        this.policy = Objects.requireNonNull(policy);
        this.simulator = Objects.requireNonNull(simulator);
    }

    public static Behavior<Command> create(ActorRef<Simulator.Command> simulator, Policy policy) {
        return Behaviors.setup((Function & Serializable)context -> new PolicyActor((ActorContext<Command>)context, simulator, policy));
    }

    public Receive<Command> createReceive() {
        return this.newReceiveBuilder().onMessage(AccessEvents.class, (Function & Serializable)msg -> this.process(msg.events)).onMessage(Finished.class, (Function & Serializable)msg -> this.finish()).build();
    }

    private Behavior<Command> process(List<AccessEvent> events) {
        this.policy.stats().stopwatch().start();
        for (AccessEvent event : events) {
            long priorMisses = this.policy.stats().missCount();
            long priorHits = this.policy.stats().hitCount();
            this.policy.record(event);
            if (this.policy.stats().hitCount() > priorHits) {
                this.policy.stats().recordHitPenalty(event.hitPenalty());
                continue;
            }
            if (this.policy.stats().missCount() <= priorMisses) continue;
            this.policy.stats().recordMissPenalty(event.missPenalty());
        }
        this.policy.stats().stopwatch().stop();
        return this;
    }

    private Behavior<Command> finish() {
        this.policy.finished();
        this.simulator.tell((Object)new Simulator.Stats(this.policy.stats()));
        return Behaviors.stopped();
    }

    public static final class Finished
    extends Command {
    }

    public static final class AccessEvents
    extends Command {
        public final List<AccessEvent> events;

        public AccessEvents(List<AccessEvent> events) {
            this.events = Objects.requireNonNull(events);
        }
    }

    public static abstract class Command {
        private Command() {
        }
    }
}

