/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.opt;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;

public final class ClairvoyantPolicy
implements Policy {
    private final Long2ObjectMap<IntPriorityQueue> accessTimes;
    private final PolicyStats policyStats;
    private final IntSortedSet data;
    private final int maximumSize;
    private Recorder recorder;
    private int infiniteTimestamp;
    private int tick;

    public ClairvoyantPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.policyStats = new PolicyStats("opt.Clairvoyant");
        this.accessTimes = new Long2ObjectOpenHashMap();
        this.infiniteTimestamp = Integer.MAX_VALUE;
        this.data = new IntRBTreeSet();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new ClairvoyantPolicy(config));
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return ImmutableSet.of();
    }

    @Override
    public void record(AccessEvent event) {
        if (this.recorder == null) {
            this.recorder = event.isPenaltyAware() ? new EventRecorder() : new KeyOnlyRecorder();
        }
        ++this.tick;
        this.recorder.add(event);
        IntPriorityQueue times = (IntPriorityQueue)this.accessTimes.get(event.key().longValue());
        if (times == null) {
            times = new IntArrayFIFOQueue();
            this.accessTimes.put(event.key().longValue(), (Object)times);
        }
        times.enqueue(this.tick);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.policyStats.stopwatch().start();
        this.recorder.process();
        this.policyStats.stopwatch().stop();
    }

    private void process(long key, double hitPenalty, double missPenalty) {
        IntPriorityQueue times = (IntPriorityQueue)this.accessTimes.get(key);
        int lastAccess = times.dequeueInt();
        boolean found = this.data.remove(lastAccess);
        if (times.isEmpty()) {
            this.data.add(this.infiniteTimestamp--);
            this.accessTimes.remove(key);
        } else {
            this.data.add(times.firstInt());
        }
        if (found) {
            this.policyStats.recordHit();
            this.policyStats.recordHitPenalty(hitPenalty);
        } else {
            this.policyStats.recordMiss();
            this.policyStats.recordMissPenalty(missPenalty);
            if (this.data.size() > this.maximumSize) {
                this.evict();
            }
        }
    }

    private void evict() {
        this.data.remove(this.data.lastInt());
        this.policyStats.recordEviction();
    }

    private final class EventRecorder
    implements Recorder {
        private final Queue<AccessEvent> future;

        EventRecorder() {
            this.future = new ArrayDeque<AccessEvent>(ClairvoyantPolicy.this.maximumSize);
        }

        @Override
        public void add(AccessEvent event) {
            this.future.add(event);
        }

        @Override
        public void process() {
            while (!this.future.isEmpty()) {
                AccessEvent event = this.future.poll();
                ClairvoyantPolicy.this.process(event.key(), event.hitPenalty(), event.missPenalty());
            }
        }
    }

    private final class KeyOnlyRecorder
    implements Recorder {
        private final LongArrayFIFOQueue future;

        KeyOnlyRecorder() {
            this.future = new LongArrayFIFOQueue(ClairvoyantPolicy.this.maximumSize);
        }

        @Override
        public void add(AccessEvent event) {
            this.future.enqueue(event.key().longValue());
        }

        @Override
        public void process() {
            while (!this.future.isEmpty()) {
                ClairvoyantPolicy.this.process(this.future.dequeueLong(), 0.0, 0.0);
            }
        }
    }

    private static interface Recorder {
        public void add(AccessEvent var1);

        public void process();
    }
}

