/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;

public final class Ehcache3Policy
implements Policy.KeyOnlyPolicy {
    private final Cache<Object, Object> cache;
    private final CacheManager cacheManager;
    private final PolicyStats policyStats = new PolicyStats("product.Ehcache3");
    private final long maximumSize;
    private long size;

    public Ehcache3Policy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        this.cache = this.cacheManager.createCache("ehcache3", CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(settings.maximumSize(), (ResourceUnit)EntryUnit.ENTRIES)).build());
        this.maximumSize = settings.maximumSize();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new Ehcache3Policy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.putIfAbsent((Object)key, (Object)key);
        if (value == null) {
            ++this.size;
            this.policyStats.recordMiss();
            if (this.size > this.maximumSize) {
                this.policyStats.recordEviction();
                --this.size;
            }
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.cacheManager.close();
    }
}

