/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.umass.storage;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.stream.LongStream;

public final class StorageTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    static final int BLOCK_SIZE = 512;

    public StorageTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() throws IOException {
        return this.lines().flatMapToLong(line -> {
            String[] array = line.split(",", 5);
            if (array.length <= 4) {
                return LongStream.empty();
            }
            long startBlock = Long.parseLong(array[1]);
            int size = Integer.parseInt(array[2]);
            int sequence = IntMath.divide((int)size, (int)512, (RoundingMode)RoundingMode.UP);
            char readWrite = Character.toLowerCase(array[3].charAt(0));
            return readWrite == 'w' ? LongStream.empty() : LongStream.range(startBlock, startBlock + (long)sequence);
        });
    }
}

