/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.parallel;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import java.io.IOException;
import java.util.stream.LongStream;

public final class TencentBlockTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    static final int BLOCK_SIZE = 512;
    static final char READ = '0';

    public TencentBlockTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() throws IOException {
        return this.lines().map(line -> line.split(",")).filter(array -> array[3].charAt(0) == '0').flatMapToLong(array -> {
            long offset = Long.parseLong(array[1]);
            long startBlock = offset / 512L;
            int sequence = Integer.parseInt(array[2]);
            int volumeId = Integer.parseInt(array[4]);
            long key = (long)volumeId << 31 | (long)Long.hashCode(startBlock);
            return LongStream.range(key, key + (long)sequence);
        });
    }
}

