/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.parallel;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import java.io.IOException;
import java.util.stream.LongStream;

public final class K5cloudTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    static final int BLOCK_SIZE = 512;

    public K5cloudTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() throws IOException {
        return this.lines().map(line -> line.split(",")).filter(array -> array[2].charAt(0) == 'R').flatMapToLong(array -> {
            long offset = Long.parseLong(array[3]);
            long startBlock = offset / 512L;
            int sequence = Integer.parseInt(array[4]) / 512;
            return LongStream.range(startBlock, startBlock + (long)sequence);
        });
    }
}

