/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public final class RandomWindowTinyLfuPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final Admittor admittor;
    final int maximumSize;
    final Random random;
    final Node[] window;
    final Node[] main;
    int windowSize;
    int mainSize;

    public RandomWindowTinyLfuPolicy(double percentMain, RandomWindowTinyLfuSettings settings) {
        String name = String.format("sketch.RandomWindowTinyLfu (%.0f%%)", 100.0 * (1.0 - percentMain));
        this.policyStats = new PolicyStats(name);
        this.admittor = new TinyLfu(settings.config(), this.policyStats);
        this.random = new Random(settings.randomSeed());
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        int maxMain = (int)((double)this.maximumSize * percentMain);
        this.window = new Node[this.maximumSize - maxMain + 1];
        this.main = new Node[maxMain + 1];
    }

    public static Set<Policy> policies(Config config) {
        RandomWindowTinyLfuSettings settings = new RandomWindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new RandomWindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            node = new Node(key, this.windowSize);
            this.policyStats.recordOperation();
            this.policyStats.recordMiss();
            this.window[node.index] = node;
            this.data.put(key, (Object)node);
            ++this.windowSize;
            this.evict();
        } else {
            this.policyStats.recordOperation();
            this.policyStats.recordHit();
        }
    }

    private void evict() {
        if (this.windowSize <= this.window.length - 1) {
            return;
        }
        Node candidate = this.window[this.random.nextInt(this.window.length)];
        this.removeFromTable(this.window, candidate);
        --this.windowSize;
        this.main[this.mainSize] = candidate;
        candidate.index = this.mainSize++;
        if (this.data.size() > this.maximumSize) {
            Node victim = this.main[this.random.nextInt(this.main.length)];
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.removeFromTable(this.main, evict);
            this.data.remove(evict.key);
            --this.mainSize;
            this.policyStats.recordEviction();
        }
    }

    private void removeFromTable(Node[] table, Node node) {
        int last = table.length - 1;
        table[node.index] = table[last];
        table[node.index].index = node.index;
        table[last] = null;
    }

    static final class RandomWindowTinyLfuSettings
    extends BasicSettings {
        public RandomWindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("random-window-tiny-lfu.percent-main");
        }
    }

    static final class Node {
        final long key;
        int index;

        public Node(long key, int index) {
            this.index = index;
            this.key = key;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("index", this.index).toString();
        }
    }
}

