/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.AbstractTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class BinaryTraceReader
extends AbstractTraceReader {
    public BinaryTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Stream<AccessEvent> events() throws IOException {
        DataInputStream input = new DataInputStream(new BufferedInputStream(this.readFile()));
        Stream<AccessEvent> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TraceIterator(input), 16), false);
        return (Stream)stream.onClose(() -> Closeables.closeQuietly((InputStream)input));
    }

    protected abstract AccessEvent readEvent(DataInputStream var1) throws IOException;

    private final class TraceIterator
    implements Iterator<AccessEvent> {
        final DataInputStream input;
        AccessEvent next;
        boolean ready;

        TraceIterator(DataInputStream input) {
            this.input = Objects.requireNonNull(input);
        }

        @Override
        public boolean hasNext() {
            if (this.ready) {
                return true;
            }
            try {
                this.next = BinaryTraceReader.this.readEvent(this.input);
                this.ready = true;
                return true;
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public AccessEvent next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.ready = false;
            return this.next;
        }
    }
}

