/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;

public final class FeedbackTinyLfuPolicy
implements Policy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final TinyLfu admittor;
    private final int maximumSize;
    private final Node head;
    private int gain;
    private final int maxGain;
    private int sample;
    private int sampled;
    private int adjusted;
    private final int sampleSize;
    private final Membership feedback;
    boolean debug;

    public FeedbackTinyLfuPolicy(Config config) {
        FeedbackTinyLfuSettings settings = new FeedbackTinyLfuSettings(config);
        this.policyStats = new PolicyStats("sketch.FeedbackTinyLfu");
        this.admittor = new TinyLfu(settings.config(), this.policyStats);
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.head = new Node();
        this.maxGain = Math.min(15, settings.maximumInsertionGain());
        this.sampleSize = Math.min(settings.maximumSampleSize(), this.maximumSize);
        this.feedback = settings.membership().filter().create(settings.filterConfig(this.sampleSize));
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new FeedbackTinyLfuPolicy(config));
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        if (this.sample % this.sampleSize == 0) {
            ++this.sampled;
        }
        if (this.sample % (this.sampleSize / 2) == 0) {
            this.feedback.clear();
        }
        ++this.sample;
        this.admittor.record(key);
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else {
            this.onHit(node);
            this.policyStats.recordHit();
        }
    }

    private void onMiss(long key) {
        for (int i = 0; i < this.gain; ++i) {
            this.admittor.record(key);
        }
        Node node = new Node(key);
        node.appendToTail(this.head);
        this.data.put(key, (Object)node);
        this.evict(node);
    }

    private void onHit(Node node) {
        node.moveToTail(this.head);
    }

    private void evict(Node candidate) {
        if (this.data.size() > this.maximumSize) {
            Node evict;
            Node victim = this.head.next;
            if (this.admittor.admit(candidate.key, victim.key)) {
                evict = victim;
            } else if (this.adapt(candidate)) {
                evict = victim;
            } else {
                evict = candidate;
                this.feedback.put(candidate.key);
            }
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    private boolean adapt(Node candidate) {
        if (this.adjusted == this.sampled) {
            return false;
        }
        if (this.feedback.mightContain(candidate.key)) {
            if (this.sampled >= this.adjusted + this.gain) {
                this.adjusted = this.sampled;
                if (this.gain < this.maxGain) {
                    ++this.gain;
                }
            }
            return true;
        }
        if (this.sampled > this.adjusted + this.gain + 1) {
            this.adjusted = this.sampled;
            if (this.gain > 0) {
                --this.gain;
            }
        }
        return false;
    }

    @Override
    public void finished() {
        if (this.debug) {
            System.out.println("recency gain = " + this.gain);
        }
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0, (Object)this.data.size());
    }

    static final class FeedbackTinyLfuSettings
    extends BasicSettings {
        public FeedbackTinyLfuSettings(Config config) {
            super(config);
        }

        public int maximumInsertionGain() {
            return this.config().getInt("feedback-tiny-lfu.maximum-insertion-gain");
        }

        public int maximumSampleSize() {
            return this.config().getInt("feedback-tiny-lfu.maximum-sample-size");
        }

        public double adaptiveFpp() {
            return this.config().getDouble("feedback-tiny-lfu.adaptive-fpp");
        }

        public Config filterConfig(int sampleSize) {
            ImmutableMap properties = ImmutableMap.of((Object)"membership.fpp", (Object)this.adaptiveFpp(), (Object)"maximum-size", (Object)sampleSize);
            return ConfigFactory.parseMap((Map)properties).withFallback((ConfigMergeable)this.config());
        }
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key) {
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).toString();
        }
    }
}

