/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.sim;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.List;

public final class MiniSimClimber
implements HillClimber {
    private static final HashFunction hasher = Hashing.murmur3_32((int)2134516034);
    private final WindowTinyLfuPolicy[] minis;
    private final int cacheSize;
    private final int period;
    private final int R;
    private int sample;
    private long[] prevMisses;
    private double prevPercent;

    public MiniSimClimber(Config config) {
        MiniSimSettings settings = new MiniSimSettings(config);
        this.R = settings.maximumSize() / 1000 > 100 ? 1000 : settings.maximumSize() / 100;
        WindowTinyLfuPolicy.WindowTinyLfuSettings simulationSettings = new WindowTinyLfuPolicy.WindowTinyLfuSettings(ConfigFactory.parseString((String)("maximum-size = " + settings.maximumSize() / this.R)).withFallback((ConfigMergeable)config));
        this.prevPercent = 1.0 - settings.percentMain().get(0);
        this.cacheSize = settings.maximumSize();
        this.period = settings.minisimPeriod();
        this.minis = new WindowTinyLfuPolicy[101];
        this.prevMisses = new long[101];
        for (int i = 0; i < this.minis.length; ++i) {
            double percentMain = 1.0 - (double)i / 100.0;
            this.minis[i] = new WindowTinyLfuPolicy(percentMain, simulationSettings);
        }
    }

    @Override
    public void onHit(long key, HillClimber.QueueType queue, boolean isFull) {
        this.onAccess(key);
    }

    @Override
    public void onMiss(long key, boolean isFull) {
        this.onAccess(key);
    }

    private void onAccess(long key) {
        ++this.sample;
        if (Math.floorMod(hasher.hashLong(key).asInt(), this.R) < 1) {
            for (WindowTinyLfuPolicy policy : this.minis) {
                policy.record(key);
            }
        }
    }

    @Override
    public HillClimber.Adaptation adapt(double windowSize, double probationSize, double protectedSize, boolean isFull) {
        if (this.sample <= this.period) {
            return HillClimber.Adaptation.hold();
        }
        long[] periodMisses = new long[101];
        for (int i = 0; i < this.minis.length; ++i) {
            periodMisses[i] = this.minis[i].stats().missCount() - this.prevMisses[i];
            this.prevMisses[i] = this.minis[i].stats().missCount();
        }
        int minIndex = 0;
        for (int i = 1; i < periodMisses.length; ++i) {
            if (periodMisses[i] >= periodMisses[minIndex]) continue;
            minIndex = i;
        }
        this.sample = 0;
        double oldPercent = this.prevPercent;
        this.prevPercent = minIndex < 80 ? (double)minIndex / 100.0 : 0.8;
        double newPercent = this.prevPercent;
        return newPercent > oldPercent ? HillClimber.Adaptation.increaseWindow((int)((newPercent - oldPercent) * (double)this.cacheSize)) : HillClimber.Adaptation.decreaseWindow((int)((oldPercent - newPercent) * (double)this.cacheSize));
    }

    static final class MiniSimSettings
    extends BasicSettings {
        public MiniSimSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("hill-climber-window-tiny-lfu.percent-main");
        }

        public int minisimPeriod() {
            return this.config().getInt("hill-climber-window-tiny-lfu.minisim.period");
        }
    }
}

