/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.inference;

import com.github.benmanes.caffeine.cache.simulator.policy.sketch.Indicator;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimberWindowTinyLfuPolicy;
import com.typesafe.config.Config;

public final class IndicatorClimber
implements HillClimber {
    private final Indicator indicator;
    private final int cacheSize;
    private double prevPercent;

    public IndicatorClimber(Config config) {
        HillClimberWindowTinyLfuPolicy.HillClimberWindowTinyLfuSettings settings = new HillClimberWindowTinyLfuPolicy.HillClimberWindowTinyLfuSettings(config);
        this.prevPercent = 1.0 - settings.percentMain().get(0);
        this.cacheSize = settings.maximumSize();
        this.indicator = new Indicator(config);
    }

    @Override
    public void onHit(long key, HillClimber.QueueType queue, boolean isFull) {
        if (isFull) {
            this.indicator.record(key);
        }
    }

    @Override
    public void onMiss(long key, boolean isFull) {
        if (isFull) {
            this.indicator.record(key);
        }
    }

    @Override
    public HillClimber.Adaptation adapt(double windowSize, double probationSize, double protectedSize, boolean isFull) {
        if (this.indicator.getSample() != 50000L) {
            return HillClimber.Adaptation.hold();
        }
        double newPercent = this.indicator.getIndicator() * 80.0 / 100.0;
        double oldPercent = this.prevPercent;
        this.prevPercent = newPercent;
        this.indicator.reset();
        return newPercent > oldPercent ? HillClimber.Adaptation.increaseWindow((int)((newPercent - oldPercent) * (double)this.cacheSize)) : HillClimber.Adaptation.decreaseWindow((int)((oldPercent - newPercent) * (double)this.cacheSize));
    }
}

