/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.tukaani.xz.XZInputStream;

public abstract class AbstractTraceReader
implements TraceReader {
    private static final int BUFFER_SIZE = 65536;
    protected final List<String> filePaths;

    public AbstractTraceReader(List<String> filePaths) {
        this.filePaths = Objects.requireNonNull(filePaths);
    }

    protected InputStream readFiles() throws IOException {
        ArrayList<InputStream> inputs = new ArrayList<InputStream>(this.filePaths.size());
        for (String filePath : this.filePaths) {
            inputs.add(this.readFile(filePath));
        }
        return new SequenceInputStream(Collections.enumeration(inputs));
    }

    private InputStream readFile(String filePath) throws IOException {
        BufferedInputStream input = new BufferedInputStream(this.openFile(filePath), 65536);
        input.mark(100);
        try {
            return new XZInputStream((InputStream)input);
        }
        catch (IOException e) {
            input.reset();
            try {
                return new CompressorStreamFactory().createCompressorInputStream((InputStream)input);
            }
            catch (CompressorException e2) {
                input.reset();
                try {
                    return new ArchiveStreamFactory().createArchiveInputStream((InputStream)input);
                }
                catch (ArchiveException e3) {
                    input.reset();
                    return input;
                }
            }
        }
    }

    private InputStream openFile(String filePath) throws IOException {
        Path file = Paths.get(filePath, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        InputStream input = this.getClass().getResourceAsStream(filePath);
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)("Could not find file: " + filePath));
        return input;
    }
}

