/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.membership;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.github.benmanes.caffeine.cache.simulator.membership.bloom.BloomFilter;
import com.github.benmanes.caffeine.cache.simulator.membership.bloom.GuavaBloomFilter;
import com.typesafe.config.Config;

public enum FilterType {
    CAFFEINE{

        @Override
        public Membership create(long expectedInsertions, double fpp, Config config) {
            int randomSeed = new BasicSettings(config).randomSeed();
            return new BloomFilter(expectedInsertions, fpp, randomSeed);
        }

        public String toString() {
            return "Caffeine";
        }
    }
    ,
    GUAVA{

        @Override
        public Membership create(long expectedInsertions, double fpp, Config config) {
            return new GuavaBloomFilter(expectedInsertions, fpp);
        }

        public String toString() {
            return "Guava";
        }
    };


    public abstract Membership create(long var1, double var3, Config var5);
}

