/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.processor;

import com.github.benmanes.caffeine.jcache.processor.Action;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.integration.CacheLoader;
import javax.cache.processor.MutableEntry;

public final class EntryProcessorEntry<K, V>
implements MutableEntry<K, V> {
    private final K key;
    private V value;
    private Action action;
    private Optional<CacheLoader<K, V>> cacheLoader;

    public EntryProcessorEntry(K key, @Nullable V value, Optional<CacheLoader<K, V>> cacheLoader) {
        this.cacheLoader = cacheLoader;
        this.action = Action.NONE;
        this.value = value;
        this.key = key;
    }

    public boolean exists() {
        return this.getValue() != null;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        if (this.action != Action.NONE) {
            return this.value;
        }
        if (this.value != null) {
            this.action = Action.READ;
        } else if (this.cacheLoader.isPresent()) {
            this.value = this.cacheLoader.get().load(this.key);
            this.cacheLoader = Optional.empty();
            if (this.value != null) {
                this.action = Action.LOADED;
            }
        }
        return this.value;
    }

    public void remove() {
        this.action = this.action == Action.CREATED ? Action.NONE : Action.DELETED;
        this.value = null;
    }

    public void setValue(V value) {
        Objects.requireNonNull(value);
        if (this.action != Action.CREATED) {
            this.action = this.exists() ? Action.UPDATED : Action.CREATED;
        }
        this.value = value;
    }

    public Action getAction() {
        return this.action;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (!clazz.isInstance(this)) {
            throw new IllegalArgumentException("Class " + clazz + " is unknown to this implementation");
        }
        EntryProcessorEntry castedEntry = this;
        return (T)castedEntry;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cache.Entry)) {
            return false;
        }
        Cache.Entry entry = (Cache.Entry)o;
        return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
    }

    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.getValue() == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        return this.key + "=" + this.getValue();
    }
}

