/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.management;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nonnegative;
import javax.cache.management.CacheStatisticsMXBean;

public final class JCacheStatisticsMXBean
implements CacheStatisticsMXBean {
    private final LongAdder removals = new LongAdder();
    private final LongAdder expiries = new LongAdder();
    private final LongAdder puts = new LongAdder();
    private final LongAdder hits = new LongAdder();
    private final LongAdder misses = new LongAdder();
    private final LongAdder evictions = new LongAdder();
    private final LongAdder putTimeNanos = new LongAdder();
    private final LongAdder getTimeNanos = new LongAdder();
    private final LongAdder removeTimeNanos = new LongAdder();
    private volatile boolean enabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void clear() {
        this.puts.reset();
        this.misses.reset();
        this.removals.reset();
        this.expiries.reset();
        this.hits.reset();
        this.evictions.reset();
        this.getTimeNanos.reset();
        this.putTimeNanos.reset();
        this.removeTimeNanos.reset();
    }

    public long getCacheHits() {
        return this.hits.sum();
    }

    public float getCacheHitPercentage() {
        long requestCount = this.getCacheGets();
        return requestCount == 0L ? 0.0f : 100.0f * ((float)this.getCacheHits() / (float)requestCount);
    }

    public void recordHits(@Nonnegative long count) {
        if (this.enabled) {
            this.hits.add(count);
        }
    }

    public long getCacheMisses() {
        return this.misses.sum();
    }

    public float getCacheMissPercentage() {
        long requestCount = this.getCacheGets();
        return requestCount == 0L ? 0.0f : 100.0f * ((float)this.getCacheMisses() / (float)requestCount);
    }

    public void recordMisses(@Nonnegative long count) {
        if (this.enabled) {
            this.misses.add(count);
        }
    }

    public long getCacheGets() {
        return this.getCacheHits() + this.getCacheMisses();
    }

    public long getCachePuts() {
        return this.puts.sum();
    }

    public void recordPuts(@Nonnegative long count) {
        if (this.enabled && count != 0L) {
            this.puts.add(count);
        }
    }

    public long getCacheRemovals() {
        return this.removals.sum();
    }

    public void recordRemovals(@Nonnegative long count) {
        if (this.enabled) {
            this.removals.add(count);
        }
    }

    public long getCacheEvictions() {
        return this.evictions.sum();
    }

    public void recordEvictions(@Nonnegative long count) {
        if (this.enabled) {
            this.evictions.add(count);
        }
    }

    public float getAverageGetTime() {
        return JCacheStatisticsMXBean.average(this.getCacheGets(), this.getTimeNanos.sum());
    }

    public void recordGetTime(long durationNanos) {
        if (this.enabled && durationNanos != 0L) {
            this.getTimeNanos.add(durationNanos);
        }
    }

    public float getAveragePutTime() {
        return JCacheStatisticsMXBean.average(this.getCachePuts(), this.putTimeNanos.sum());
    }

    public void recordPutTime(long durationNanos) {
        if (this.enabled && durationNanos != 0L) {
            this.putTimeNanos.add(durationNanos);
        }
    }

    public float getAverageRemoveTime() {
        return JCacheStatisticsMXBean.average(this.getCacheRemovals(), this.removeTimeNanos.sum());
    }

    public void recordRemoveTime(long durationNanos) {
        if (this.enabled && durationNanos != 0L) {
            this.removeTimeNanos.add(durationNanos);
        }
    }

    private static float average(long requestCount, long opsTimeNanos) {
        if (requestCount == 0L || opsTimeNanos == 0L) {
            return 0.0f;
        }
        long opsTimeMicro = TimeUnit.NANOSECONDS.toMicros(opsTimeNanos);
        return (float)opsTimeMicro / (float)requestCount;
    }
}

