/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.rtftohtml.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import org.bbottema.rtftohtml.RTF2HTMLConverter;
import org.bbottema.rtftohtml.impl.RTF2HTMLException;
import org.jetbrains.annotations.NotNull;

public class RTF2HTMLConverterJEditorPane
implements RTF2HTMLConverter {
    public static final RTF2HTMLConverter INSTANCE = new RTF2HTMLConverterJEditorPane();

    private RTF2HTMLConverterJEditorPane() {
    }

    @Override
    @NotNull
    public String rtf2html(@NotNull String rtf) {
        JEditorPane p = new JEditorPane();
        p.setContentType("text/rtf");
        EditorKit kitRtf = p.getEditorKitForContentType("text/rtf");
        try {
            kitRtf.read(new StringReader(rtf), p.getDocument(), 0);
            StringWriter writer = new StringWriter();
            EditorKit editorKitForContentType = p.getEditorKitForContentType("text/html");
            editorKitForContentType.write(writer, p.getDocument(), 0, p.getDocument().getLength());
            return ((Object)writer).toString();
        }
        catch (IOException | BadLocationException e) {
            throw new RTF2HTMLException("Could not convert RTF to HTML.", e);
        }
    }
}

