/*
 * Decompiled with CFR 0.152.
 */
package com.badoualy.stepperindicator;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.badoualy.stepperindicator.R;
import java.util.ArrayList;
import java.util.List;

public class StepperIndicator
extends View
implements ViewPager.OnPageChangeListener {
    private static final int DEFAULT_ANIMATION_DURATION = 250;
    private static final float EXPAND_MARK = 1.3f;
    private Paint circlePaint;
    private Paint linePaint;
    private Paint lineDonePaint;
    private Paint lineDoneAnimatedPaint;
    private Paint indicatorPaint;
    private List<Path> linePathList = new ArrayList<Path>();
    private float animProgress;
    private float animIndicatorRadius;
    private float animCheckRadius;
    private float lineLength;
    private float circleRadius;
    private float checkRadius;
    private float indicatorRadius;
    private float lineMargin;
    private int animDuration;
    private int stepCount;
    private int currentStep;
    private int previousStep;
    private float[] indicators;
    private ViewPager pager;
    private Bitmap doneIcon;
    private AnimatorSet animatorSet;
    private ObjectAnimator lineAnimator;
    private ObjectAnimator indicatorAnimator;
    private ObjectAnimator checkAnimator;

    public StepperIndicator(Context context) {
        this(context, null);
    }

    public StepperIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepperIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public StepperIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        int defaultPrimaryColor;
        Resources resources = this.getResources();
        int defaultCircleColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_circle_color);
        float defaultCircleRadius = resources.getDimension(R.dimen.stpi_default_circle_radius);
        float defaultCircleStrokeWidth = resources.getDimension(R.dimen.stpi_default_circle_stroke_width);
        int defaultIndicatorColor = defaultPrimaryColor = StepperIndicator.getPrimaryColor(context);
        float defaultIndicatorRadius = resources.getDimension(R.dimen.stpi_default_indicator_radius);
        float defaultLineStrokeWidth = resources.getDimension(R.dimen.stpi_default_line_stroke_width);
        float defaultLineMargin = resources.getDimension(R.dimen.stpi_default_line_margin);
        int defaultLineColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_line_color);
        int defaultLineDoneColor = defaultPrimaryColor;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StepperIndicator, defStyleAttr, 0);
        this.circlePaint = new Paint();
        this.circlePaint.setStrokeWidth(a.getDimension(R.styleable.StepperIndicator_stpi_circleStrokeWidth, defaultCircleStrokeWidth));
        this.circlePaint.setStyle(Paint.Style.STROKE);
        this.circlePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_circleColor, defaultCircleColor));
        this.circlePaint.setAntiAlias(true);
        this.indicatorPaint = new Paint(this.circlePaint);
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.indicatorPaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_indicatorColor, defaultIndicatorColor));
        this.indicatorPaint.setAntiAlias(true);
        this.linePaint = new Paint();
        this.linePaint.setStrokeWidth(a.getDimension(R.styleable.StepperIndicator_stpi_lineStrokeWidth, defaultLineStrokeWidth));
        this.linePaint.setStrokeCap(Paint.Cap.ROUND);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_lineColor, defaultLineColor));
        this.linePaint.setAntiAlias(true);
        this.lineDonePaint = new Paint(this.linePaint);
        this.lineDonePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_lineDoneColor, defaultLineDoneColor));
        this.lineDoneAnimatedPaint = new Paint(this.lineDonePaint);
        this.circleRadius = a.getDimension(R.styleable.StepperIndicator_stpi_circleRadius, defaultCircleRadius);
        this.checkRadius = this.circleRadius + this.circlePaint.getStrokeWidth() / 2.0f;
        this.animIndicatorRadius = this.indicatorRadius = a.getDimension(R.styleable.StepperIndicator_stpi_indicatorRadius, defaultIndicatorRadius);
        this.animCheckRadius = this.checkRadius;
        this.lineMargin = a.getDimension(R.styleable.StepperIndicator_stpi_lineMargin, defaultLineMargin);
        this.setStepCount(a.getInteger(R.styleable.StepperIndicator_stpi_stepCount, 2));
        this.animDuration = a.getInteger(R.styleable.StepperIndicator_stpi_animDuration, 250);
        a.recycle();
        this.doneIcon = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.ic_done_white_18dp);
        if (this.isInEditMode()) {
            this.currentStep = Math.max((int)Math.ceil((float)this.stepCount / 2.0f), 1);
        }
    }

    public static int getPrimaryColor(Context context) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimary, value, true);
        return value.data;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.compute();
    }

    private void compute() {
        int i;
        this.indicators = new float[this.stepCount];
        this.linePathList.clear();
        float startX = this.circleRadius * 1.3f + this.circlePaint.getStrokeWidth() / 2.0f;
        float divider = ((float)this.getMeasuredWidth() - startX * 2.0f) / (float)(this.stepCount - 1);
        this.lineLength = divider - (this.circleRadius * 2.0f + this.circlePaint.getStrokeWidth()) - this.lineMargin * 2.0f;
        for (i = 0; i < this.indicators.length; ++i) {
            this.indicators[i] = startX + divider * (float)i;
        }
        for (i = 0; i < this.indicators.length - 1; ++i) {
            float position = (this.indicators[i] + this.indicators[i + 1]) / 2.0f - this.lineLength / 2.0f;
            Path linePath = new Path();
            linePath.moveTo(position, (float)(this.getMeasuredHeight() / 2));
            linePath.lineTo(position + this.lineLength, (float)(this.getMeasuredHeight() / 2));
            this.linePathList.add(linePath);
        }
    }

    protected void onDraw(Canvas canvas) {
        float centerY = (float)this.getMeasuredHeight() / 2.0f;
        boolean inAnimation = false;
        boolean inLineAnimation = false;
        boolean inIndicatorAnimation = false;
        boolean inCheckAnimation = false;
        if (Build.VERSION.SDK_INT >= 11) {
            inAnimation = this.animatorSet != null && this.animatorSet.isRunning();
            inLineAnimation = this.lineAnimator != null && this.lineAnimator.isRunning();
            inIndicatorAnimation = this.indicatorAnimator != null && this.indicatorAnimator.isRunning();
            inCheckAnimation = this.checkAnimator != null && this.checkAnimator.isRunning();
        }
        boolean drawToNext = this.previousStep == this.currentStep - 1;
        boolean drawFromNext = this.previousStep == this.currentStep + 1;
        for (int i = 0; i < this.indicators.length; ++i) {
            float indicator = this.indicators[i];
            boolean drawCheck = i < this.currentStep || drawFromNext && i == this.currentStep;
            canvas.drawCircle(indicator, centerY, this.circleRadius, this.circlePaint);
            if (i == this.currentStep && !drawFromNext || i == this.previousStep && drawFromNext && inAnimation) {
                canvas.drawCircle(indicator, centerY, this.animIndicatorRadius, this.indicatorPaint);
            }
            if (drawCheck) {
                float radius = this.checkRadius;
                if (i == this.previousStep && drawToNext || i == this.currentStep && drawFromNext) {
                    radius = this.animCheckRadius;
                }
                canvas.drawCircle(indicator, centerY, radius, this.indicatorPaint);
                if (!this.isInEditMode() && (i != this.previousStep && i != this.currentStep || !inCheckAnimation && (i != this.currentStep || inAnimation))) {
                    canvas.drawBitmap(this.doneIcon, indicator - (float)(this.doneIcon.getWidth() / 2), centerY - (float)(this.doneIcon.getHeight() / 2), null);
                }
            }
            if (i >= this.linePathList.size()) continue;
            if (i >= this.currentStep) {
                canvas.drawPath(this.linePathList.get(i), this.linePaint);
                if (i != this.currentStep || !drawFromNext || !inLineAnimation && !inIndicatorAnimation) continue;
                canvas.drawPath(this.linePathList.get(i), this.lineDoneAnimatedPaint);
                continue;
            }
            if (i == this.currentStep - 1 && drawToNext && inLineAnimation) {
                canvas.drawPath(this.linePathList.get(i), this.linePaint);
                canvas.drawPath(this.linePathList.get(i), this.lineDoneAnimatedPaint);
                continue;
            }
            canvas.drawPath(this.linePathList.get(i), this.lineDonePaint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredHeight = (int)Math.ceil(this.circleRadius * 1.3f * 2.0f + this.circlePaint.getStrokeWidth());
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : this.getSuggestedMinimumWidth();
        int height = heightMode == 0x40000000 ? heightSize : desiredHeight;
        this.setMeasuredDimension(width, height);
    }

    public void setStepCount(int stepCount) {
        if (stepCount < 2) {
            throw new IllegalArgumentException("stepCount must be >= 2");
        }
        this.stepCount = stepCount;
        this.currentStep = 0;
        this.compute();
        this.invalidate();
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    @UiThread
    public void setCurrentStep(int currentStep) {
        if (currentStep < 0 || currentStep > this.stepCount) {
            throw new IllegalArgumentException("Invalid step value " + currentStep);
        }
        this.previousStep = this.currentStep;
        this.currentStep = currentStep;
        if (Build.VERSION.SDK_INT >= 11) {
            if (this.animatorSet != null) {
                this.animatorSet.cancel();
            }
            this.animatorSet = null;
            this.lineAnimator = null;
            this.indicatorAnimator = null;
            if (currentStep == this.previousStep + 1) {
                this.animatorSet = new AnimatorSet();
                this.lineAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animProgress", (float[])new float[]{1.0f, 0.0f});
                this.checkAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animCheckRadius", (float[])new float[]{this.indicatorRadius, this.checkRadius * 1.3f, this.checkRadius});
                this.animIndicatorRadius = 0.0f;
                this.indicatorAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animIndicatorRadius", (float[])new float[]{0.0f, this.indicatorRadius * 1.4f, this.indicatorRadius});
                this.animatorSet.play((Animator)this.lineAnimator).with((Animator)this.checkAnimator).before((Animator)this.indicatorAnimator);
            } else if (currentStep == this.previousStep - 1) {
                this.animatorSet = new AnimatorSet();
                this.indicatorAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animIndicatorRadius", (float[])new float[]{this.indicatorRadius, 0.0f});
                this.animProgress = 1.0f;
                this.lineDoneAnimatedPaint.setPathEffect(null);
                this.lineAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animProgress", (float[])new float[]{0.0f, 1.0f});
                this.animCheckRadius = this.checkRadius;
                this.checkAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animCheckRadius", (float[])new float[]{this.checkRadius, this.indicatorRadius});
                this.animatorSet.playSequentially(new Animator[]{this.indicatorAnimator, this.lineAnimator, this.checkAnimator});
            }
            if (this.animatorSet != null) {
                this.lineAnimator.setDuration((long)Math.min(500, this.animDuration));
                this.lineAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.indicatorAnimator.setDuration(this.lineAnimator.getDuration() / 2L);
                this.checkAnimator.setDuration(this.lineAnimator.getDuration() / 2L);
                this.animatorSet.start();
            }
        }
        this.invalidate();
    }

    public void setAnimProgress(float animProgress) {
        this.animProgress = animProgress;
        this.lineDoneAnimatedPaint.setPathEffect(StepperIndicator.createPathEffect(this.lineLength, animProgress, 0.0f));
        this.invalidate();
    }

    public void setAnimIndicatorRadius(float animIndicatorRadius) {
        this.animIndicatorRadius = animIndicatorRadius;
        this.invalidate();
    }

    public void setAnimCheckRadius(float animCheckRadius) {
        this.animCheckRadius = animCheckRadius;
        this.invalidate();
    }

    private static PathEffect createPathEffect(float pathLength, float phase, float offset) {
        return new DashPathEffect(new float[]{pathLength, pathLength}, Math.max(phase * pathLength, offset));
    }

    public void setViewPager(ViewPager pager) {
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.setViewPager(pager, pager.getAdapter().getCount());
    }

    public void setViewPager(ViewPager pager, boolean keepLastPage) {
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.setViewPager(pager, pager.getAdapter().getCount() - (keepLastPage ? 1 : 0));
    }

    public void setViewPager(ViewPager pager, int stepCount) {
        if (this.pager == pager) {
            return;
        }
        if (this.pager != null) {
            pager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.pager = pager;
        this.stepCount = stepCount;
        this.currentStep = 0;
        pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.setCurrentStep(position);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentStep = savedState.currentStep;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentStep = this.currentStep;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        private int currentStep;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentStep = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentStep);
        }
    }
}

