/*
 * Decompiled with CFR 0.152.
 */
package com.badoualy.stepperindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import com.badoualy.stepperindicator.R;

public class StepperIndicator
extends View
implements ViewPager.OnPageChangeListener {
    private Paint circlePaint;
    private Paint circleDonePaint;
    private Paint linePaint;
    private Paint lineDonePaint;
    private Paint indicatorPaint;
    private float circleRadius;
    private float indicatorRadius;
    private float lineMargin;
    private int stepCount;
    private int currentStep = 1;
    private float[] indicators;
    private ViewPager pager;
    private Bitmap doneIcon;

    public StepperIndicator(Context context) {
        this(context, null);
    }

    public StepperIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepperIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public StepperIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        Resources resources = this.getResources();
        int defaultCircleColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_circle_color);
        float defaultCircleRadius = resources.getDimension(R.dimen.stpi_default_circle_radius);
        float defaultCircleStrokeWidth = resources.getDimension(R.dimen.stpi_default_circle_stroke_width);
        int defaultIndicatorColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_indicator_color);
        float defaultIndicatorRadius = resources.getDimension(R.dimen.stpi_default_indicator_radius);
        float defaultLineStrokeWidth = resources.getDimension(R.dimen.stpi_default_line_stroke_width);
        float defaultLineMargin = resources.getDimension(R.dimen.stpi_default_line_margin);
        int defaultLineColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_line_color);
        int defaultLineDoneColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_line_done_color);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StepperIndicator, defStyleAttr, 0);
        this.circlePaint = new Paint();
        this.circlePaint.setStrokeWidth(defaultCircleStrokeWidth);
        this.circlePaint.setStyle(Paint.Style.STROKE);
        this.circlePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_circleColor, defaultCircleColor));
        this.circlePaint.setAntiAlias(true);
        this.indicatorPaint = new Paint();
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.indicatorPaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_indicatorColor, defaultIndicatorColor));
        this.indicatorPaint.setAntiAlias(true);
        this.circleDonePaint = new Paint(this.circlePaint);
        this.circleDonePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.circleDonePaint.setColor(this.indicatorPaint.getColor());
        this.linePaint = new Paint();
        this.linePaint.setStrokeWidth(a.getDimension(R.styleable.StepperIndicator_stpi_lineStrokeWidth, defaultLineStrokeWidth));
        this.linePaint.setStrokeCap(Paint.Cap.ROUND);
        this.linePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_lineColor, defaultLineColor));
        this.linePaint.setAntiAlias(true);
        this.lineDonePaint = new Paint(this.linePaint);
        this.lineDonePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_lineDoneColor, defaultLineDoneColor));
        this.circleRadius = a.getDimension(R.styleable.StepperIndicator_stpi_circleRadius, defaultCircleRadius);
        this.indicatorRadius = a.getDimension(R.styleable.StepperIndicator_stpi_indicatorRadius, defaultIndicatorRadius);
        this.lineMargin = a.getDimension(R.styleable.StepperIndicator_stpi_lineMargin, defaultLineMargin);
        this.setStepCount(a.getInteger(R.styleable.StepperIndicator_stpi_stepCount, 2));
        a.recycle();
        this.doneIcon = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.ic_done_white_18dp);
        if (this.isInEditMode()) {
            this.currentStep = Math.max((int)Math.ceil((float)this.stepCount / 2.0f), 2);
        }
    }

    protected void onDraw(Canvas canvas) {
        int i;
        float centerY;
        float circleCenterY = centerY = (float)this.getMeasuredHeight() / 2.0f;
        float lineCenterY = centerY;
        float startX = this.circleRadius + this.circlePaint.getStrokeWidth() / 2.0f;
        float divider = ((float)this.getMeasuredWidth() - startX * 2.0f) / (float)(this.stepCount - 1);
        float lineLength = divider - (this.circleRadius * 2.0f + this.circlePaint.getStrokeWidth()) - this.lineMargin * 2.0f;
        for (i = 0; i < this.indicators.length; ++i) {
            this.indicators[i] = startX + divider * (float)i;
        }
        for (i = 0; i < this.indicators.length; ++i) {
            float indicator = this.indicators[i];
            if (i >= this.currentStep - 1) {
                canvas.drawCircle(indicator, circleCenterY, this.circleRadius, this.circlePaint);
                if (i == this.currentStep - 1) {
                    canvas.drawCircle(indicator, circleCenterY, this.indicatorRadius, this.indicatorPaint);
                }
            } else {
                canvas.drawCircle(indicator, circleCenterY, this.circleRadius, this.circleDonePaint);
                if (!this.isInEditMode()) {
                    canvas.drawBitmap(this.doneIcon, indicator - (float)(this.doneIcon.getWidth() / 2), circleCenterY - (float)(this.doneIcon.getHeight() / 2), null);
                }
            }
            if (i == this.indicators.length - 1) continue;
            float lineCenterX = (indicator + this.indicators[i + 1]) / 2.0f;
            canvas.drawLine(lineCenterX - lineLength / 2.0f, lineCenterY, lineCenterX + lineLength / 2.0f, lineCenterY, i < this.currentStep - 1 ? this.lineDonePaint : this.linePaint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredHeight = (int)Math.ceil(this.circleRadius * 2.0f + this.circlePaint.getStrokeWidth());
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : this.getSuggestedMinimumWidth();
        int height = heightMode == 0x40000000 ? heightSize : desiredHeight;
        this.setMeasuredDimension(width, height);
    }

    public void setStepCount(int stepCount) {
        if (stepCount < 2) {
            throw new IllegalArgumentException("stepCount must be >= 2");
        }
        this.stepCount = stepCount;
        this.indicators = new float[stepCount];
        this.invalidate();
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
        this.invalidate();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setViewPager(ViewPager pager) {
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.setViewPager(pager, pager.getAdapter().getCount());
    }

    public void setViewPager(ViewPager pager, int stepCount) {
        if (this.pager == pager) {
            return;
        }
        if (this.pager != null) {
            pager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.pager = pager;
        this.stepCount = stepCount;
        this.currentStep = 1;
        pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    public void reset() {
        this.currentStep = 1;
        this.invalidate();
    }

    public void complete() {
        this.currentStep = this.stepCount;
        this.invalidate();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.setCurrentStep(position + 1);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentStep = savedState.currentStep;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentStep = this.currentStep;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        private int currentStep;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentStep = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentStep);
        }
    }
}

