/*
 * Decompiled with CFR 0.152.
 */
package com.andrognito.pinlockview;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.andrognito.pinlockview.R;
import com.andrognito.pinlockview.ResourceUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IndicatorDots
extends LinearLayout {
    private static final int DEFAULT_PIN_LENGTH = 4;
    private int mDotDiameter;
    private int mDotSpacing;
    private int mFillDrawable;
    private int mEmptyDrawable;
    private int mPinLength;
    private int mIndicatorType;
    private int mPreviousLength;

    public IndicatorDots(Context context) {
        this(context, null);
    }

    public IndicatorDots(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndicatorDots(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PinLockView);
        try {
            this.mDotDiameter = (int)typedArray.getDimension(R.styleable.PinLockView_dotDiameter, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_dot_diameter));
            this.mDotSpacing = (int)typedArray.getDimension(R.styleable.PinLockView_dotSpacing, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_dot_spacing));
            this.mFillDrawable = typedArray.getResourceId(R.styleable.PinLockView_dotFilledBackground, R.drawable.dot_filled);
            this.mEmptyDrawable = typedArray.getResourceId(R.styleable.PinLockView_dotEmptyBackground, R.drawable.dot_empty);
            this.mPinLength = typedArray.getInt(R.styleable.PinLockView_pinLength, 4);
            this.mIndicatorType = typedArray.getInt(R.styleable.PinLockView_indicatorType, 0);
        }
        finally {
            typedArray.recycle();
        }
        this.initView(context);
    }

    private void initView(Context context) {
        ViewCompat.setLayoutDirection((View)this, (int)0);
        if (this.mIndicatorType == 0) {
            for (int i = 0; i < this.mPinLength; ++i) {
                View dot = new View(context);
                this.emptyDot(dot);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mDotDiameter, this.mDotDiameter);
                params.setMargins(this.mDotSpacing, 0, this.mDotSpacing, 0);
                dot.setLayoutParams((ViewGroup.LayoutParams)params);
                this.addView(dot);
            }
        } else if (this.mIndicatorType == 2) {
            this.setLayoutTransition(new LayoutTransition());
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndicatorType != 0) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            params.height = this.mDotDiameter;
            this.requestLayout();
        }
    }

    void updateDot(int length) {
        if (this.mIndicatorType == 0) {
            if (length > 0) {
                if (length > this.mPreviousLength) {
                    this.fillDot(this.getChildAt(length - 1));
                } else {
                    this.emptyDot(this.getChildAt(length));
                }
                this.mPreviousLength = length;
            } else {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View v = this.getChildAt(i);
                    this.emptyDot(v);
                }
                this.mPreviousLength = 0;
            }
        } else if (length > 0) {
            if (length > this.mPreviousLength) {
                View dot = new View(this.getContext());
                this.fillDot(dot);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mDotDiameter, this.mDotDiameter);
                params.setMargins(this.mDotSpacing, 0, this.mDotSpacing, 0);
                dot.setLayoutParams((ViewGroup.LayoutParams)params);
                this.addView(dot, length - 1);
            } else {
                this.removeViewAt(length);
            }
            this.mPreviousLength = length;
        } else {
            this.removeAllViews();
            this.mPreviousLength = 0;
        }
    }

    private void emptyDot(View dot) {
        dot.setBackgroundResource(this.mEmptyDrawable);
    }

    private void fillDot(View dot) {
        dot.setBackgroundResource(this.mFillDrawable);
    }

    public int getPinLength() {
        return this.mPinLength;
    }

    public void setPinLength(int pinLength) {
        this.mPinLength = pinLength;
        this.removeAllViews();
        this.initView(this.getContext());
    }

    public int getIndicatorType() {
        return this.mIndicatorType;
    }

    public void setIndicatorType(int type) {
        this.mIndicatorType = type;
        this.removeAllViews();
        this.initView(this.getContext());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndicatorType {
        public static final int FIXED = 0;
        public static final int FILL = 1;
        public static final int FILL_WITH_ANIMATION = 2;
    }
}

