/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.graphics.drawable.DrawerArrowDrawable;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.suggestions.SearchSuggestionsAdapter;
import com.arlib.floatingsearchview.suggestions.model.SearchSuggestion;
import com.arlib.floatingsearchview.util.Util;
import com.arlib.floatingsearchview.util.adapter.GestureDetectorListenerAdapter;
import com.arlib.floatingsearchview.util.adapter.OnItemTouchListenerAdapter;
import com.arlib.floatingsearchview.util.adapter.TextWatcherAdapter;
import com.arlib.floatingsearchview.util.view.MenuView;
import com.arlib.floatingsearchview.util.view.SearchInputView;
import com.bartoszlipinski.viewpropertyobjectanimator.ViewPropertyObjectAnimator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FloatingSearchView
extends FrameLayout {
    private static final String TAG = FloatingSearchView.class.getSimpleName();
    private static final int CARD_VIEW_TOP_BOTTOM_SHADOW_HEIGHT = 3;
    private static final int CARD_VIEW_CORNERS_HEIGHT = 2;
    private static final int CARD_VIEW_CORNERS_AND_TOP_BOTTOM_SHADOW_HEIGHT = 5;
    private static final long CLEAR_BTN_FADE_ANIM_DURATION = 500L;
    private static final int CLEAR_BTN_WIDTH_DP = 48;
    private static final int LEFT_MENU_WIDTH_AND_MARGIN_START_DP = 52;
    private static final float MENU_BUTTON_PROGRESS_ARROW = 1.0f;
    private static final float MENU_BUTTON_PROGRESS_HAMBURGER = 0.0f;
    private static final int BACKGROUND_DRAWABLE_ALPHA_SEARCH_FOCUSED = 150;
    private static final int BACKGROUND_DRAWABLE_ALPHA_SEARCH_NOT_FOCUSED = 0;
    private static final int BACKGROUND_FADE_ANIM_DURATION = 250;
    private static final int MENU_ICON_ANIM_DURATION = 250;
    private static final Interpolator SUGGEST_ITEM_ADD_ANIM_INTERPOLATOR = new LinearInterpolator();
    public static final int LEFT_ACTION_MODE_SHOW_HAMBURGER = 1;
    public static final int LEFT_ACTION_MODE_SHOW_SEARCH = 2;
    public static final int LEFT_ACTION_MODE_SHOW_HOME = 3;
    public static final int LEFT_ACTION_MODE_NO_LEFT_ACTION = 4;
    private static final int LEFT_ACTION_MODE_NOT_SET = -1;
    private static final int ATTRS_SEARCH_BAR_LEFT_ACTION_MODE_DEFAULT = 4;
    private static final boolean ATTRS_SHOW_MOVE_UP_SUGGESTION_DEFAULT = false;
    private static final boolean ATTRS_DISMISS_ON_OUTSIDE_TOUCH_DEFAULT = true;
    private static final boolean ATTRS_DISMISS_ON_KEYBOARD_DISMISS_DEFAULT = false;
    private static final boolean ATTRS_SEARCH_BAR_SHOW_SEARCH_KEY_DEFAULT = true;
    private static final int ATTRS_QUERY_TEXT_SIZE_SP_DEFAULT = 18;
    private static final int ATTRS_SUGGESTION_TEXT_SIZE_SP_DEFAULT = 18;
    private static final boolean ATTRS_SHOW_DIM_BACKGROUND_DEFAULT = true;
    private static final int ATTRS_SUGGESTION_ANIM_DURATION_DEFAULT = 250;
    private static final int ATTRS_SEARCH_BAR_MARGIN_DEFAULT = 0;
    private Activity mHostActivity;
    private View mMainLayout;
    private Drawable mBackgroundDrawable;
    private boolean mDimBackground;
    private boolean mDismissOnOutsideTouch = true;
    private boolean mIsFocused;
    private OnFocusChangeListener mFocusChangeListener;
    private CardView mQuerySection;
    private OnSearchListener mSearchListener;
    private SearchInputView mSearchInput;
    private int mQueryTextSize;
    private boolean mCloseSearchOnSofteKeyboardDismiss;
    private String mTitleText;
    private boolean mIsTitleSet;
    private int mSearchInputTextColor = -1;
    private int mSearchInputHintColor = -1;
    private View mSearchInputParent;
    private String mOldQuery = "";
    private OnQueryChangeListener mQueryListener;
    private ImageView mLeftAction;
    private OnLeftMenuClickListener mOnMenuClickListener;
    private OnHomeActionClickListener mOnHomeActionClickListener;
    private ProgressBar mSearchProgress;
    private DrawerArrowDrawable mMenuBtnDrawable;
    private Drawable mIconBackArrow;
    private Drawable mIconSearch;
    int mLeftActionMode = -1;
    private int mLeftActionIconColor;
    private String mSearchHint;
    private boolean mShowSearchKey;
    private boolean mMenuOpen = false;
    private MenuView mMenuView;
    private int mMenuId = -1;
    private int mActionMenuItemColor;
    private int mOverflowIconColor;
    private OnMenuItemClickListener mActionMenuItemListener;
    private ImageView mClearButton;
    private int mClearBtnColor;
    private Drawable mIconClear;
    private int mBackgroundColor;
    private boolean mSkipQueryFocusChangeEvent;
    private boolean mSkipTextChangeEvent;
    private View mDivider;
    private int mDividerColor;
    private RelativeLayout mSuggestionsSection;
    private View mSuggestionListContainer;
    private RecyclerView mSuggestionsList;
    private int mSuggestionTextColor = -1;
    private int mSuggestionRightIconColor;
    private SearchSuggestionsAdapter mSuggestionsAdapter;
    private SearchSuggestionsAdapter.OnBindSuggestionCallback mOnBindSuggestionCallback;
    private int mSuggestionsTextSizePx;
    private boolean mIsInitialLayout = true;
    private boolean mIsSuggestionsSectionHeightSet;
    private boolean mShowMoveUpSuggestion = false;
    private OnSuggestionsListHeightChanged mOnSuggestionsListHeightChanged;
    private long mSuggestionSectionAnimDuration;
    private OnClearSearchActionListener mOnClearSearchActionListener;
    private OnSuggestionSecHeightSetListener mSuggestionSecHeightListener;
    private DrawerLayout.DrawerListener mDrawerListener = new DrawerListener();

    public FloatingSearchView(Context context) {
        this(context, null);
    }

    public FloatingSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mHostActivity = Util.getHostActivity(this.getContext());
        LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        this.mMainLayout = FloatingSearchView.inflate((Context)this.getContext(), (int)R.layout.floating_search_layout, (ViewGroup)this);
        this.mBackgroundDrawable = new ColorDrawable(-16777216);
        this.mQuerySection = (CardView)this.findViewById(R.id.search_query_section);
        this.mClearButton = (ImageView)this.findViewById(R.id.clear_btn);
        this.mSearchInput = (SearchInputView)this.findViewById(R.id.search_bar_text);
        this.mSearchInputParent = this.findViewById(R.id.search_input_parent);
        this.mLeftAction = (ImageView)this.findViewById(R.id.left_action);
        this.mSearchProgress = (ProgressBar)this.findViewById(R.id.search_bar_search_progress);
        this.initDrawables();
        this.mClearButton.setImageDrawable(this.mIconClear);
        this.mMenuView = (MenuView)this.findViewById(R.id.menu_view);
        this.mDivider = this.findViewById(R.id.divider);
        this.mSuggestionsSection = (RelativeLayout)this.findViewById(R.id.search_suggestions_section);
        this.mSuggestionListContainer = this.findViewById(R.id.suggestions_list_container);
        this.mSuggestionsList = (RecyclerView)this.findViewById(R.id.suggestions_list);
        this.setupViews(attrs);
    }

    private void initDrawables() {
        this.mMenuBtnDrawable = new DrawerArrowDrawable(this.getContext());
        this.mIconClear = Util.getWrappedDrawable(this.getContext(), R.drawable.ic_clear_black_24dp);
        this.mIconBackArrow = Util.getWrappedDrawable(this.getContext(), R.drawable.ic_arrow_back_black_24dp);
        this.mIconSearch = Util.getWrappedDrawable(this.getContext(), R.drawable.ic_search_black_24dp);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mIsInitialLayout) {
            int finalHeight;
            int addedHeight = 3 * Util.dpToPx(5);
            this.mSuggestionsSection.getLayoutParams().height = finalHeight = this.mSuggestionsSection.getHeight() + addedHeight;
            this.mSuggestionsSection.requestLayout();
            ViewTreeObserver vto = this.mSuggestionListContainer.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (FloatingSearchView.this.mSuggestionsSection.getHeight() == finalHeight) {
                        Util.removeGlobalLayoutObserver(FloatingSearchView.this.mSuggestionListContainer, this);
                        FloatingSearchView.this.mIsSuggestionsSectionHeightSet = true;
                        FloatingSearchView.this.moveSuggestListToInitialPos();
                        if (FloatingSearchView.this.mSuggestionSecHeightListener != null) {
                            FloatingSearchView.this.mSuggestionSecHeightListener.onSuggestionSecHeightSet();
                            FloatingSearchView.this.mSuggestionSecHeightListener = null;
                        }
                    }
                }
            });
            this.mIsInitialLayout = false;
            this.refreshDimBackground();
            if (this.isInEditMode()) {
                this.inflateOverflowMenu(this.mMenuId);
            }
        }
    }

    private void setupViews(AttributeSet attrs) {
        this.mSuggestionsSection.setEnabled(false);
        if (attrs != null) {
            this.applyXmlAttributes(attrs);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(this.mBackgroundDrawable);
        } else {
            this.setBackgroundDrawable(this.mBackgroundDrawable);
        }
        this.setupQueryBar();
        if (!this.isInEditMode()) {
            this.setupSuggestionSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyXmlAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FloatingSearchView);
        try {
            int searchBarWidth;
            this.mQuerySection.getLayoutParams().width = searchBarWidth = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarWidth, -1);
            this.mDivider.getLayoutParams().width = searchBarWidth;
            this.mSuggestionListContainer.getLayoutParams().width = searchBarWidth;
            int searchBarLeftMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginLeft, 0);
            int searchBarTopMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginTop, 0);
            int searchBarRightMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginRight, 0);
            FrameLayout.LayoutParams querySectionLP = (FrameLayout.LayoutParams)this.mQuerySection.getLayoutParams();
            FrameLayout.LayoutParams dividerLP = (FrameLayout.LayoutParams)this.mDivider.getLayoutParams();
            LinearLayout.LayoutParams suggestListSectionLP = (LinearLayout.LayoutParams)this.mSuggestionsSection.getLayoutParams();
            int cardPadding = Util.dpToPx(3);
            querySectionLP.setMargins(searchBarLeftMargin, searchBarTopMargin, searchBarRightMargin, 0);
            dividerLP.setMargins(searchBarLeftMargin + cardPadding, 0, searchBarRightMargin + cardPadding, ((ViewGroup.MarginLayoutParams)this.mDivider.getLayoutParams()).bottomMargin);
            suggestListSectionLP.setMargins(searchBarLeftMargin, 0, searchBarRightMargin, 0);
            this.mQuerySection.setLayoutParams((ViewGroup.LayoutParams)querySectionLP);
            this.mDivider.setLayoutParams((ViewGroup.LayoutParams)dividerLP);
            this.mSuggestionsSection.setLayoutParams((ViewGroup.LayoutParams)suggestListSectionLP);
            this.setQueryTextSize(a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchInputTextSize, 18));
            this.setSearchHint(a.getString(R.styleable.FloatingSearchView_floatingSearch_searchHint));
            this.setShowSearchKey(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showSearchKey, true));
            this.setCloseSearchOnKeyboardDismiss(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_close_search_on_keyboard_dismiss, false));
            this.setDismissOnOutsideClick(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_dismissOnOutsideTouch, true));
            this.setSuggestionItemTextSize(a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchSuggestionTextSize, Util.spToPx(18)));
            this.mLeftActionMode = a.getInt(R.styleable.FloatingSearchView_floatingSearch_leftActionMode, 4);
            if (a.hasValue(R.styleable.FloatingSearchView_floatingSearch_menu)) {
                this.mMenuId = a.getResourceId(R.styleable.FloatingSearchView_floatingSearch_menu, -1);
            }
            this.setDimBackground(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_dimBackground, true));
            this.setShowMoveUpSuggestion(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showMoveSuggestionUp, false));
            this.mSuggestionSectionAnimDuration = a.getInt(R.styleable.FloatingSearchView_floatingSearch_suggestionsListAnimDuration, 250);
            this.setBackgroundColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_backgroundColor, Util.getColor(this.getContext(), R.color.background)));
            this.setLeftActionIconColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_leftActionColor, Util.getColor(this.getContext(), R.color.left_action_icon)));
            this.setActionMenuOverflowColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_actionMenuOverflowColor, Util.getColor(this.getContext(), R.color.overflow_icon_color)));
            this.setMenuItemIconColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_menuItemIconColor, Util.getColor(this.getContext(), R.color.menu_icon_color)));
            this.setDividerColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_dividerColor, Util.getColor(this.getContext(), R.color.divider)));
            this.setClearBtnColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_clearBtnColor, Util.getColor(this.getContext(), R.color.clear_btn_color)));
            int viewTextColor = a.getColor(R.styleable.FloatingSearchView_floatingSearch_viewTextColor, Util.getColor(this.getContext(), R.color.dark_gray));
            this.setViewTextColor(viewTextColor);
            this.setQueryTextColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_viewSearchInputTextColor, viewTextColor));
            this.setSuggestionsTextColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_viewSuggestionItemTextColor, viewTextColor));
            this.setHintTextColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_hintTextColor, Util.getColor(this.getContext(), R.color.hint_color)));
            this.setSuggestionRightIconColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_suggestionRightIconColor, Util.getColor(this.getContext(), R.color.gray_active_icon)));
        }
        finally {
            a.recycle();
        }
    }

    private void setupQueryBar() {
        this.mSearchInput.setTextColor(this.mSearchInputTextColor);
        this.mSearchInput.setHintTextColor(this.mSearchInputHintColor);
        if (!this.isInEditMode() && this.mHostActivity != null) {
            this.mHostActivity.getWindow().setSoftInputMode(32);
        }
        ViewTreeObserver vto = this.mQuerySection.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Util.removeGlobalLayoutObserver((View)FloatingSearchView.this.mQuerySection, this);
                FloatingSearchView.this.inflateOverflowMenu(FloatingSearchView.this.mMenuId);
            }
        });
        this.mMenuView.setMenuCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                if (FloatingSearchView.this.mActionMenuItemListener != null) {
                    FloatingSearchView.this.mActionMenuItemListener.onActionMenuItemSelected(item);
                }
                return false;
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
        this.mMenuView.setOnVisibleWidthChanged(new MenuView.OnVisibleWidthChangedListener(){

            @Override
            public void onItemsMenuVisibleWidthChanged(int newVisibleWidth) {
                FloatingSearchView.this.handleOnVisibleMenuItemsWidthChanged(newVisibleWidth);
            }
        });
        this.mMenuView.setActionIconColor(this.mActionMenuItemColor);
        this.mMenuView.setOverflowColor(this.mOverflowIconColor);
        this.mClearButton.setVisibility(4);
        this.mClearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingSearchView.this.mSearchInput.setText("");
                if (FloatingSearchView.this.mOnClearSearchActionListener != null) {
                    FloatingSearchView.this.mOnClearSearchActionListener.onClearSearchClicked();
                }
            }
        });
        this.mSearchInput.addTextChangedListener(new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (FloatingSearchView.this.mSkipTextChangeEvent || !FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.mSkipTextChangeEvent = false;
                } else {
                    if (FloatingSearchView.this.mSearchInput.getText().toString().length() != 0 && FloatingSearchView.this.mClearButton.getVisibility() == 4) {
                        FloatingSearchView.this.mClearButton.setAlpha(0.0f);
                        FloatingSearchView.this.mClearButton.setVisibility(0);
                        ViewCompat.animate((View)FloatingSearchView.this.mClearButton).alpha(1.0f).setDuration(500L).start();
                    } else if (FloatingSearchView.this.mSearchInput.getText().toString().length() == 0) {
                        FloatingSearchView.this.mClearButton.setVisibility(4);
                    }
                    if (FloatingSearchView.this.mQueryListener != null && FloatingSearchView.this.mIsFocused && !FloatingSearchView.this.mOldQuery.equals(FloatingSearchView.this.mSearchInput.getText().toString())) {
                        FloatingSearchView.this.mQueryListener.onSearchTextChanged(FloatingSearchView.this.mOldQuery, FloatingSearchView.this.mSearchInput.getText().toString());
                    }
                }
                FloatingSearchView.this.mOldQuery = FloatingSearchView.this.mSearchInput.getText().toString();
            }
        });
        this.mSearchInput.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (FloatingSearchView.this.mSkipQueryFocusChangeEvent) {
                    FloatingSearchView.this.mSkipQueryFocusChangeEvent = false;
                } else if (hasFocus != FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.setSearchFocusedInternal(hasFocus);
                }
            }
        });
        this.mSearchInput.setOnKeyboardDismissedListener(new SearchInputView.OnKeyboardDismissedListener(){

            @Override
            public void onKeyboardDismissed() {
                if (FloatingSearchView.this.mCloseSearchOnSofteKeyboardDismiss) {
                    FloatingSearchView.this.setSearchFocusedInternal(false);
                }
            }
        });
        this.mSearchInput.setOnSearchKeyListener(new SearchInputView.OnKeyboardSearchKeyClickListener(){

            @Override
            public void onSearchKeyClicked() {
                if (FloatingSearchView.this.mSearchListener != null) {
                    FloatingSearchView.this.mSearchListener.onSearchAction(FloatingSearchView.this.getQuery());
                }
                FloatingSearchView.this.mSkipTextChangeEvent = true;
                FloatingSearchView.this.mSkipTextChangeEvent = true;
                if (FloatingSearchView.this.mIsTitleSet) {
                    FloatingSearchView.this.setSearchBarTitle(FloatingSearchView.this.getQuery());
                } else {
                    FloatingSearchView.this.setSearchText(FloatingSearchView.this.getQuery());
                }
                FloatingSearchView.this.setSearchFocusedInternal(false);
            }
        });
        this.mLeftAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FloatingSearchView.this.isSearchBarFocused()) {
                    FloatingSearchView.this.setSearchFocusedInternal(false);
                } else {
                    switch (FloatingSearchView.this.mLeftActionMode) {
                        case 1: {
                            FloatingSearchView.this.toggleLeftMenu();
                            break;
                        }
                        case 2: {
                            FloatingSearchView.this.setSearchFocusedInternal(true);
                            break;
                        }
                        case 3: {
                            if (FloatingSearchView.this.mOnHomeActionClickListener == null) break;
                            FloatingSearchView.this.mOnHomeActionClickListener.onHomeClicked();
                            break;
                        }
                    }
                }
            }
        });
        this.refreshLeftIcon();
    }

    private void handleOnVisibleMenuItemsWidthChanged(int menuItemsWidth) {
        if (menuItemsWidth == 0) {
            this.mClearButton.setTranslationX((float)(-Util.dpToPx(4)));
            int paddingRight = Util.dpToPx(4);
            paddingRight = this.mIsFocused ? (paddingRight += Util.dpToPx(48)) : (paddingRight += Util.dpToPx(14));
            this.mSearchInput.setPadding(0, 0, paddingRight, 0);
        } else {
            this.mClearButton.setTranslationX((float)(-menuItemsWidth));
            int paddingRight = menuItemsWidth;
            if (this.mIsFocused) {
                paddingRight += Util.dpToPx(48);
            }
            this.mSearchInput.setPadding(0, 0, paddingRight, 0);
        }
    }

    public void setLeftActionIconColor(int color2) {
        this.mLeftActionIconColor = color2;
        this.mMenuBtnDrawable.setColor(color2);
        DrawableCompat.setTint((Drawable)this.mIconBackArrow, (int)color2);
        DrawableCompat.setTint((Drawable)this.mIconSearch, (int)color2);
    }

    public void setClearBtnColor(int color2) {
        this.mClearBtnColor = color2;
        DrawableCompat.setTint((Drawable)this.mIconClear, (int)this.mClearBtnColor);
    }

    public void setMenuItemIconColor(int color2) {
        this.mActionMenuItemColor = color2;
        if (this.mMenuView != null) {
            this.mMenuView.setActionIconColor(this.mActionMenuItemColor);
        }
    }

    public void setActionMenuOverflowColor(int color2) {
        this.mOverflowIconColor = color2;
        if (this.mMenuView != null) {
            this.mMenuView.setOverflowColor(this.mOverflowIconColor);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        if (this.mQuerySection != null && this.mSuggestionsList != null) {
            this.mQuerySection.setCardBackgroundColor(color2);
            this.mSuggestionsList.setBackgroundColor(color2);
        }
    }

    public void setViewTextColor(int color2) {
        this.setSuggestionsTextColor(color2);
        this.setQueryTextColor(color2);
    }

    public void setSuggestionsTextColor(int color2) {
        this.mSuggestionTextColor = color2;
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setTextColor(this.mSuggestionTextColor);
        }
    }

    public void setSuggestionsAnimDuration(long duration) {
        this.mSuggestionSectionAnimDuration = duration;
    }

    public void setQueryTextColor(int color2) {
        this.mSearchInputTextColor = color2;
        if (this.mSearchInput != null) {
            this.mSearchInput.setTextColor(this.mSearchInputTextColor);
        }
    }

    public void setQueryTextSize(int sizePx) {
        this.mQueryTextSize = sizePx;
        this.mSearchInput.setTextSize(this.mQueryTextSize);
    }

    public void setHintTextColor(int color2) {
        this.mSearchInputHintColor = color2;
        if (this.mSearchInput != null) {
            this.mSearchInput.setHintTextColor(color2);
        }
    }

    public void setDividerColor(int color2) {
        this.mDividerColor = color2;
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(this.mDividerColor);
        }
    }

    public void setSuggestionRightIconColor(int color2) {
        this.mSuggestionRightIconColor = color2;
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setRightIconColor(this.mSuggestionRightIconColor);
        }
    }

    private void setSuggestionItemTextSize(int sizePx) {
        this.mSuggestionsTextSizePx = sizePx;
    }

    public void setLeftActionMode(int mode) {
        this.mLeftActionMode = mode;
        this.refreshLeftIcon();
    }

    private void refreshLeftIcon() {
        int leftActionWidthAndMarginLeft = Util.dpToPx(52);
        int queryTranslationX = 0;
        this.mLeftAction.setVisibility(0);
        switch (this.mLeftActionMode) {
            case 1: {
                this.mLeftAction.setImageDrawable((Drawable)this.mMenuBtnDrawable);
                this.mMenuBtnDrawable.setProgress(0.0f);
                break;
            }
            case 2: {
                this.mLeftAction.setImageDrawable(this.mIconSearch);
                break;
            }
            case 3: {
                this.mLeftAction.setImageDrawable((Drawable)this.mMenuBtnDrawable);
                this.mMenuBtnDrawable.setProgress(1.0f);
                break;
            }
            case 4: {
                this.mLeftAction.setVisibility(4);
                queryTranslationX = -leftActionWidthAndMarginLeft;
            }
        }
        this.mSearchInputParent.setTranslationX((float)queryTranslationX);
    }

    private void toggleLeftMenu() {
        if (this.mMenuOpen) {
            this.closeMenu(true);
        } else {
            this.openMenu(true);
        }
    }

    public void setMenuIconProgress(float progress) {
        this.mMenuBtnDrawable.setProgress(progress);
        if (progress == 0.0f) {
            this.closeMenu(false);
        } else if ((double)progress == 1.0) {
            this.openMenu(false);
        }
    }

    public void openMenu(boolean withAnim) {
        this.mMenuOpen = true;
        this.openMenuDrawable(this.mMenuBtnDrawable, withAnim);
        if (this.mOnMenuClickListener != null) {
            this.mOnMenuClickListener.onMenuOpened();
        }
    }

    public void closeMenu(boolean withAnim) {
        this.mMenuOpen = false;
        this.closeMenuDrawable(this.mMenuBtnDrawable, withAnim);
        if (this.mOnMenuClickListener != null) {
            this.mOnMenuClickListener.onMenuClosed();
        }
    }

    public void setLeftMenuOpen(boolean isOpen) {
        this.mMenuOpen = isOpen;
        this.mMenuBtnDrawable.setProgress(isOpen ? 1.0f : 0.0f);
    }

    public void showProgress() {
        this.mLeftAction.setVisibility(8);
        this.mSearchProgress.setAlpha(0.0f);
        this.mSearchProgress.setVisibility(0);
        ObjectAnimator.ofFloat((Object)this.mSearchProgress, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).start();
    }

    public void hideProgress() {
        this.mSearchProgress.setVisibility(8);
        this.mLeftAction.setAlpha(0.0f);
        this.mLeftAction.setVisibility(0);
        ObjectAnimator.ofFloat((Object)this.mLeftAction, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).start();
    }

    public void inflateOverflowMenu(int menuId) {
        this.mMenuId = menuId;
        this.mMenuView.reset(menuId, this.actionMenuAvailWidth());
        if (this.mIsFocused) {
            this.mMenuView.hideIfRoomItems(false);
        }
    }

    private int actionMenuAvailWidth() {
        if (this.isInEditMode()) {
            return this.mQuerySection.getMeasuredWidth() / 2;
        }
        return this.mQuerySection.getWidth() / 2;
    }

    public void setSearchHint(String searchHint) {
        this.mSearchHint = searchHint != null ? searchHint : this.getResources().getString(R.string.abc_search_hint);
        this.mSearchInput.setHint(this.mSearchHint);
    }

    public void setShowSearchKey(boolean show) {
        this.mShowSearchKey = show;
        if (show) {
            this.mSearchInput.setImeOptions(3);
        } else {
            this.mSearchInput.setImeOptions(1);
        }
    }

    public void setCloseSearchOnKeyboardDismiss(boolean closeSearchOnKeyboardDismiss) {
        this.mCloseSearchOnSofteKeyboardDismiss = closeSearchOnKeyboardDismiss;
    }

    public void setDismissOnOutsideClick(boolean enable) {
        this.mDismissOnOutsideTouch = enable;
        this.mSuggestionsSection.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (FloatingSearchView.this.mDismissOnOutsideTouch && FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.setSearchFocusedInternal(false);
                }
                return true;
            }
        });
    }

    public void setDimBackground(boolean dimEnabled) {
        this.mDimBackground = dimEnabled;
        this.refreshDimBackground();
    }

    private void refreshDimBackground() {
        if (this.mDimBackground && this.mIsFocused) {
            this.mBackgroundDrawable.setAlpha(150);
        } else {
            this.mBackgroundDrawable.setAlpha(0);
        }
    }

    public void setShowMoveUpSuggestion(boolean show) {
        this.mShowMoveUpSuggestion = show;
        this.refreshShowMoveUpSuggestion();
    }

    private void refreshShowMoveUpSuggestion() {
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setShowMoveUpIcon(this.mShowMoveUpSuggestion);
        }
    }

    public void setSearchFocusable(boolean focusable) {
        this.mSearchInput.setFocusable(focusable);
        this.mSearchInput.setFocusableInTouchMode(focusable);
    }

    public void setSearchBarTitle(CharSequence title) {
        this.mTitleText = title.toString();
        this.mIsTitleSet = true;
        this.mSearchInput.setText(title);
    }

    public void setSearchText(CharSequence text) {
        this.mIsTitleSet = false;
        this.setQueryText(text);
    }

    public String getQuery() {
        return this.mOldQuery;
    }

    public void clearQuery() {
        this.mSearchInput.setText("");
    }

    public boolean setSearchFocused(final boolean focused) {
        boolean updatedToNotFocused;
        boolean bl = updatedToNotFocused = !focused && this.mIsFocused;
        if (focused != this.mIsFocused && this.mSuggestionSecHeightListener == null) {
            if (this.mIsSuggestionsSectionHeightSet) {
                this.setSearchFocusedInternal(focused);
            } else {
                this.mSuggestionSecHeightListener = new OnSuggestionSecHeightSetListener(){

                    @Override
                    public void onSuggestionSecHeightSet() {
                        FloatingSearchView.this.setSearchFocusedInternal(focused);
                        FloatingSearchView.this.mSuggestionSecHeightListener = null;
                    }
                };
            }
        }
        return updatedToNotFocused;
    }

    private void setupSuggestionSection() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, true);
        this.mSuggestionsList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mSuggestionsList.setItemAnimator(null);
        final GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetectorListenerAdapter(){

            @Override
            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (FloatingSearchView.this.mHostActivity != null) {
                    Util.closeSoftKeyboard(FloatingSearchView.this.mHostActivity);
                }
                return false;
            }
        });
        this.mSuggestionsList.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new OnItemTouchListenerAdapter(){

            @Override
            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                gestureDetector.onTouchEvent(e);
                return false;
            }
        });
        this.mSuggestionsAdapter = new SearchSuggestionsAdapter(this.getContext(), this.mSuggestionsTextSizePx, new SearchSuggestionsAdapter.Listener(){

            @Override
            public void onItemSelected(SearchSuggestion item) {
                FloatingSearchView.this.mIsFocused = false;
                if (FloatingSearchView.this.mSearchListener != null) {
                    FloatingSearchView.this.mSearchListener.onSuggestionClicked(item);
                }
                FloatingSearchView.this.mSkipTextChangeEvent = true;
                if (FloatingSearchView.this.mIsTitleSet) {
                    FloatingSearchView.this.setSearchBarTitle(item.getBody());
                } else {
                    FloatingSearchView.this.setSearchText(item.getBody());
                }
                FloatingSearchView.this.setSearchFocusedInternal(false);
            }

            @Override
            public void onMoveItemToSearchClicked(SearchSuggestion item) {
                FloatingSearchView.this.setQueryText(item.getBody());
            }
        });
        this.refreshShowMoveUpSuggestion();
        this.mSuggestionsAdapter.setTextColor(this.mSuggestionTextColor);
        this.mSuggestionsAdapter.setRightIconColor(this.mSuggestionRightIconColor);
        this.mSuggestionsList.setAdapter((RecyclerView.Adapter)this.mSuggestionsAdapter);
        int cardViewBottomPadding = Util.dpToPx(5);
        this.mSuggestionsSection.setTranslationY((float)(-cardViewBottomPadding));
    }

    private void setQueryText(CharSequence text) {
        this.mSearchInput.setText(text);
        this.mSearchInput.setSelection(this.mSearchInput.getText().length());
    }

    private void moveSuggestListToInitialPos() {
        this.mSuggestionListContainer.setTranslationY((float)(-this.mSuggestionListContainer.getHeight()));
    }

    public void swapSuggestions(List<? extends SearchSuggestion> newSearchSuggestions) {
        this.swapSuggestions(newSearchSuggestions, true);
    }

    private void swapSuggestions(final List<? extends SearchSuggestion> newSearchSuggestions, final boolean withAnim) {
        this.mSuggestionsList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Util.removeGlobalLayoutObserver((View)FloatingSearchView.this.mSuggestionsList, this);
                boolean isSuggestionItemsFillRecyclerView = FloatingSearchView.this.updateSuggestionsSectionHeight(newSearchSuggestions, withAnim);
                LinearLayoutManager suggestionsListLm = (LinearLayoutManager)FloatingSearchView.this.mSuggestionsList.getLayoutManager();
                if (isSuggestionItemsFillRecyclerView) {
                    suggestionsListLm.setReverseLayout(false);
                } else {
                    Collections.reverse(newSearchSuggestions);
                    FloatingSearchView.this.mSuggestionsAdapter.notifyDataSetChanged();
                    suggestionsListLm.setReverseLayout(true);
                }
            }
        });
        this.mSuggestionsList.setAdapter((RecyclerView.Adapter)this.mSuggestionsAdapter);
        this.mSuggestionsAdapter.swapData(newSearchSuggestions);
        this.mDivider.setVisibility(!newSearchSuggestions.isEmpty() ? 0 : 8);
    }

    private boolean updateSuggestionsSectionHeight(List<? extends SearchSuggestion> newSearchSuggestions, boolean withAnim) {
        int cardTopBottomShadowPadding = Util.dpToPx(5);
        int cardRadiusSize = Util.dpToPx(3);
        int visibleSuggestionHeight = this.calculateSuggestionItemsHeight(newSearchSuggestions, this.mSuggestionListContainer.getHeight());
        int diff = this.mSuggestionListContainer.getHeight() - visibleSuggestionHeight;
        int addedTranslationYForShadowOffsets = diff <= cardTopBottomShadowPadding ? -(cardTopBottomShadowPadding - diff) : (diff < this.mSuggestionListContainer.getHeight() - cardTopBottomShadowPadding ? cardRadiusSize : 0);
        final float newTranslationY = -this.mSuggestionListContainer.getHeight() + visibleSuggestionHeight + addedTranslationYForShadowOffsets;
        final float fullyInvisibleTranslationY = -this.mSuggestionListContainer.getHeight() + cardRadiusSize;
        ViewCompat.animate((View)this.mSuggestionListContainer).cancel();
        if (withAnim) {
            ViewCompat.animate((View)this.mSuggestionListContainer).setInterpolator(SUGGEST_ITEM_ADD_ANIM_INTERPOLATOR).setDuration(this.mSuggestionSectionAnimDuration).translationY(newTranslationY).setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

                public void onAnimationUpdate(View view) {
                    if (FloatingSearchView.this.mOnSuggestionsListHeightChanged != null) {
                        float newSuggestionsHeight = Math.abs(view.getTranslationY() - fullyInvisibleTranslationY);
                        FloatingSearchView.this.mOnSuggestionsListHeightChanged.onSuggestionsListHeightChanged(newSuggestionsHeight);
                    }
                }
            }).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationCancel(View view) {
                    FloatingSearchView.this.mSuggestionListContainer.setTranslationY(newTranslationY);
                }
            }).start();
        } else {
            this.mSuggestionListContainer.setTranslationY(newTranslationY);
            if (this.mOnSuggestionsListHeightChanged != null) {
                float newSuggestionsHeight = Math.abs(this.mSuggestionListContainer.getTranslationY() - fullyInvisibleTranslationY);
                this.mOnSuggestionsListHeightChanged.onSuggestionsListHeightChanged(newSuggestionsHeight);
            }
        }
        return this.mSuggestionListContainer.getHeight() == visibleSuggestionHeight;
    }

    private int calculateSuggestionItemsHeight(List<? extends SearchSuggestion> suggestions, int max) {
        int visibleItemsHeight = 0;
        for (int i = 0; i < suggestions.size() && i < this.mSuggestionsList.getChildCount(); ++i) {
            if ((visibleItemsHeight += this.mSuggestionsList.getChildAt(i).getHeight()) <= max) continue;
            visibleItemsHeight = max;
            break;
        }
        return visibleItemsHeight;
    }

    public void setOnBindSuggestionCallback(SearchSuggestionsAdapter.OnBindSuggestionCallback callback) {
        this.mOnBindSuggestionCallback = callback;
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setOnBindSuggestionCallback(this.mOnBindSuggestionCallback);
        }
    }

    public void clearSuggestions() {
        this.swapSuggestions(new ArrayList());
    }

    public void clearSearchFocus() {
        this.setSearchFocusedInternal(false);
    }

    public boolean isSearchBarFocused() {
        return this.mIsFocused;
    }

    private void setSearchFocusedInternal(boolean focused) {
        this.mIsFocused = focused;
        if (focused) {
            this.mSearchInput.requestFocus();
            this.moveSuggestListToInitialPos();
            this.mSuggestionsSection.setVisibility(0);
            if (this.mDimBackground) {
                this.fadeInBackground();
            }
            this.handleOnVisibleMenuItemsWidthChanged(0);
            this.mMenuView.hideIfRoomItems(true);
            this.transitionInLeftSection(true);
            Util.showSoftKeyboard(this.getContext(), this.mSearchInput);
            if (this.mMenuOpen) {
                this.closeMenu(false);
            }
            if (this.mIsTitleSet) {
                this.mSkipTextChangeEvent = true;
                this.mSearchInput.setText("");
            } else {
                this.mSearchInput.setSelection(this.mSearchInput.getText().length());
            }
            this.mSearchInput.setLongClickable(true);
            this.mClearButton.setVisibility(this.mSearchInput.getText().toString().length() == 0 ? 4 : 0);
            if (this.mFocusChangeListener != null) {
                this.mFocusChangeListener.onFocus();
            }
        } else {
            this.mMainLayout.requestFocus();
            this.clearSuggestions();
            if (this.mDimBackground) {
                this.fadeOutBackground();
            }
            this.handleOnVisibleMenuItemsWidthChanged(0);
            this.mMenuView.showIfRoomItems(true);
            this.transitionOutLeftSection(true);
            this.mClearButton.setVisibility(8);
            if (this.mHostActivity != null) {
                Util.closeSoftKeyboard(this.mHostActivity);
            }
            if (this.mIsTitleSet) {
                this.mSkipTextChangeEvent = true;
                this.mSearchInput.setText(this.mTitleText);
            }
            this.mSearchInput.setLongClickable(false);
            if (this.mFocusChangeListener != null) {
                this.mFocusChangeListener.onFocusCleared();
            }
        }
        this.mSuggestionsSection.setEnabled(focused);
    }

    private void changeIcon(ImageView imageView, Drawable newIcon, boolean withAnim) {
        imageView.setImageDrawable(newIcon);
        if (withAnim) {
            ObjectAnimator fadeInVoiceInputOrClear = ObjectAnimator.ofFloat((Object)imageView, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            fadeInVoiceInputOrClear.start();
        } else {
            imageView.setAlpha(1.0f);
        }
    }

    private void transitionInLeftSection(boolean withAnim) {
        if (this.mSearchProgress.getVisibility() != 0) {
            this.mLeftAction.setVisibility(0);
        } else {
            this.mLeftAction.setVisibility(4);
        }
        switch (this.mLeftActionMode) {
            case 1: {
                this.openMenuDrawable(this.mMenuBtnDrawable, withAnim);
                if (this.mMenuOpen) break;
                break;
            }
            case 2: {
                this.mLeftAction.setImageDrawable(this.mIconBackArrow);
                if (!withAnim) break;
                this.mLeftAction.setRotation(45.0f);
                this.mLeftAction.setAlpha(0.0f);
                ObjectAnimator rotateAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).rotation(0.0f).get();
                ObjectAnimator fadeAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).alpha(1.0f).get();
                AnimatorSet animSet = new AnimatorSet();
                animSet.setDuration(500L);
                animSet.playTogether(new Animator[]{rotateAnim, fadeAnim});
                animSet.start();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mLeftAction.setImageDrawable(this.mIconBackArrow);
                if (withAnim) {
                    ObjectAnimator searchInputTransXAnim = ViewPropertyObjectAnimator.animate((View)this.mSearchInputParent).translationX(0.0f).get();
                    this.mLeftAction.setScaleX(0.5f);
                    this.mLeftAction.setScaleY(0.5f);
                    this.mLeftAction.setAlpha(0.0f);
                    this.mLeftAction.setTranslationX((float)Util.dpToPx(8));
                    ObjectAnimator transXArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).translationX(1.0f).get();
                    ObjectAnimator scaleXArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleX(1.0f).get();
                    ObjectAnimator scaleYArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleY(1.0f).get();
                    ObjectAnimator fadeArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).alpha(1.0f).get();
                    transXArrowAnim.setStartDelay(150L);
                    scaleXArrowAnim.setStartDelay(150L);
                    scaleYArrowAnim.setStartDelay(150L);
                    fadeArrowAnim.setStartDelay(150L);
                    AnimatorSet animSet = new AnimatorSet();
                    animSet.setDuration(500L);
                    animSet.playTogether(new Animator[]{searchInputTransXAnim, transXArrowAnim, scaleXArrowAnim, scaleYArrowAnim, fadeArrowAnim});
                    animSet.start();
                    break;
                }
                this.mSearchInputParent.setTranslationX(0.0f);
            }
        }
    }

    private void transitionOutLeftSection(boolean withAnim) {
        switch (this.mLeftActionMode) {
            case 1: {
                this.closeMenuDrawable(this.mMenuBtnDrawable, withAnim);
                break;
            }
            case 2: {
                this.changeIcon(this.mLeftAction, this.mIconSearch, withAnim);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mLeftAction.setImageDrawable(this.mIconBackArrow);
                if (withAnim) {
                    ObjectAnimator searchInputTransXAnim = ViewPropertyObjectAnimator.animate((View)this.mSearchInputParent).translationX((float)(-Util.dpToPx(52))).get();
                    ObjectAnimator scaleXArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleX(0.5f).get();
                    ObjectAnimator scaleYArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleY(0.5f).get();
                    ObjectAnimator fadeArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).alpha(0.5f).get();
                    scaleXArrowAnim.setDuration(300L);
                    scaleYArrowAnim.setDuration(300L);
                    fadeArrowAnim.setDuration(300L);
                    scaleXArrowAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            FloatingSearchView.this.mLeftAction.setScaleX(1.0f);
                            FloatingSearchView.this.mLeftAction.setScaleY(1.0f);
                            FloatingSearchView.this.mLeftAction.setAlpha(1.0f);
                            FloatingSearchView.this.mLeftAction.setVisibility(4);
                        }
                    });
                    AnimatorSet animSet = new AnimatorSet();
                    animSet.setDuration(350L);
                    animSet.playTogether(new Animator[]{scaleXArrowAnim, scaleYArrowAnim, fadeArrowAnim, searchInputTransXAnim});
                    animSet.start();
                    break;
                }
                this.mLeftAction.setVisibility(4);
            }
        }
    }

    public void setOnSuggestionsListHeightChanged(OnSuggestionsListHeightChanged onSuggestionsListHeightChanged) {
        this.mOnSuggestionsListHeightChanged = onSuggestionsListHeightChanged;
    }

    public void setOnQueryChangeListener(OnQueryChangeListener listener) {
        this.mQueryListener = listener;
    }

    public void setOnSearchListener(OnSearchListener listener) {
        this.mSearchListener = listener;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener listener) {
        this.mFocusChangeListener = listener;
    }

    public void setOnLeftMenuClickListener(OnLeftMenuClickListener listener) {
        this.mOnMenuClickListener = listener;
    }

    public void setOnHomeActionClickListener(OnHomeActionClickListener listener) {
        this.mOnHomeActionClickListener = listener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mActionMenuItemListener = listener;
    }

    public void setOnClearSearchActionListener(OnClearSearchActionListener listener) {
        this.mOnClearSearchActionListener = listener;
    }

    private void openMenuDrawable(final DrawerArrowDrawable drawerArrowDrawable, boolean withAnim) {
        if (withAnim) {
            ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    drawerArrowDrawable.setProgress(value);
                }
            });
            anim.setDuration(250L);
            anim.start();
        } else {
            drawerArrowDrawable.setProgress(1.0f);
        }
    }

    private void closeMenuDrawable(final DrawerArrowDrawable drawerArrowDrawable, boolean withAnim) {
        if (withAnim) {
            ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    drawerArrowDrawable.setProgress(value);
                }
            });
            anim.setDuration(250L);
            anim.start();
        } else {
            drawerArrowDrawable.setProgress(0.0f);
        }
    }

    private void fadeOutBackground() {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{150, 0});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                FloatingSearchView.this.mBackgroundDrawable.setAlpha(value);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    private void fadeInBackground() {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{0, 150});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                FloatingSearchView.this.mBackgroundDrawable.setAlpha(value);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    private boolean isRTL() {
        Configuration config = this.getResources().getConfiguration();
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.suggestions = this.mSuggestionsAdapter.getDataSet();
        savedState.isFocused = this.mIsFocused;
        savedState.query = this.getQuery();
        savedState.suggestionTextSize = this.mSuggestionsTextSizePx;
        savedState.searchHint = this.mSearchHint;
        savedState.dismissOnOutsideClick = this.mDismissOnOutsideTouch;
        savedState.showMoveSuggestionUpBtn = this.mShowMoveUpSuggestion;
        savedState.showSearchKey = this.mShowSearchKey;
        savedState.isTitleSet = this.mIsTitleSet;
        savedState.backgroundColor = this.mBackgroundColor;
        savedState.suggestionsTextColor = this.mSuggestionTextColor;
        savedState.queryTextColor = this.mSearchInputTextColor;
        savedState.searchHintTextColor = this.mSearchInputHintColor;
        savedState.actionOverflowMenueColor = this.mOverflowIconColor;
        savedState.menuItemIconColor = this.mActionMenuItemColor;
        savedState.leftIconColor = this.mLeftActionIconColor;
        savedState.clearBtnColor = this.mClearBtnColor;
        savedState.suggestionUpBtnColor = this.mSuggestionTextColor;
        savedState.dividerColor = this.mDividerColor;
        savedState.menuId = this.mMenuId;
        savedState.leftActionMode = this.mLeftActionMode;
        savedState.dimBackground = this.mDimBackground;
        savedState.dismissOnSoftKeyboardDismiss = this.mDismissOnOutsideTouch;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        final SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIsFocused = savedState.isFocused;
        this.mIsTitleSet = savedState.isTitleSet;
        this.mMenuId = savedState.menuId;
        this.mSuggestionSectionAnimDuration = savedState.suggestionsSectionAnimSuration;
        this.setSuggestionItemTextSize(savedState.suggestionTextSize);
        this.setDismissOnOutsideClick(savedState.dismissOnOutsideClick);
        this.setShowMoveUpSuggestion(savedState.showMoveSuggestionUpBtn);
        this.setShowSearchKey(savedState.showSearchKey);
        this.setSearchHint(savedState.searchHint);
        this.setBackgroundColor(savedState.backgroundColor);
        this.setSuggestionsTextColor(savedState.suggestionsTextColor);
        this.setQueryTextColor(savedState.queryTextColor);
        this.setQueryTextSize(savedState.queryTextSize);
        this.setHintTextColor(savedState.searchHintTextColor);
        this.setActionMenuOverflowColor(savedState.actionOverflowMenueColor);
        this.setMenuItemIconColor(savedState.menuItemIconColor);
        this.setLeftActionIconColor(savedState.leftIconColor);
        this.setClearBtnColor(savedState.clearBtnColor);
        this.setSuggestionRightIconColor(savedState.suggestionUpBtnColor);
        this.setDividerColor(savedState.dividerColor);
        this.setLeftActionMode(savedState.leftActionMode);
        this.setDimBackground(savedState.dimBackground);
        this.setCloseSearchOnKeyboardDismiss(savedState.dismissOnSoftKeyboardDismiss);
        this.mSuggestionsSection.setEnabled(this.mIsFocused);
        if (this.mIsFocused) {
            this.mBackgroundDrawable.setAlpha(150);
            this.mSkipTextChangeEvent = true;
            this.mSkipQueryFocusChangeEvent = true;
            this.mSuggestionsSection.setVisibility(0);
            this.mSuggestionSecHeightListener = new OnSuggestionSecHeightSetListener(){

                @Override
                public void onSuggestionSecHeightSet() {
                    FloatingSearchView.this.swapSuggestions(savedState.suggestions, false);
                    FloatingSearchView.this.mSuggestionSecHeightListener = null;
                    FloatingSearchView.this.transitionInLeftSection(false);
                }
            };
            this.mClearButton.setVisibility(savedState.query.length() == 0 ? 4 : 0);
            this.mLeftAction.setVisibility(0);
            Util.showSoftKeyboard(this.getContext(), this.mSearchInput);
        }
    }

    public void attachNavigationDrawerToMenuButton(@NonNull DrawerLayout drawerLayout) {
        drawerLayout.addDrawerListener(this.mDrawerListener);
        this.setOnLeftMenuClickListener(new NavDrawerLeftMenuClickListener(drawerLayout));
    }

    public void detachNavigationDrawerFromMenuButton(@NonNull DrawerLayout drawerLayout) {
        drawerLayout.removeDrawerListener(this.mDrawerListener);
        this.setOnLeftMenuClickListener(null);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewCompat.animate((View)this.mSuggestionListContainer).cancel();
    }

    private class NavDrawerLeftMenuClickListener
    implements OnLeftMenuClickListener {
        DrawerLayout mDrawerLayout;

        public NavDrawerLeftMenuClickListener(DrawerLayout drawerLayout) {
            this.mDrawerLayout = drawerLayout;
        }

        @Override
        public void onMenuOpened() {
            this.mDrawerLayout.openDrawer(0x800003);
        }

        @Override
        public void onMenuClosed() {
        }
    }

    private class DrawerListener
    implements DrawerLayout.DrawerListener {
        private DrawerListener() {
        }

        public void onDrawerSlide(View drawerView, float slideOffset) {
            FloatingSearchView.this.setMenuIconProgress(slideOffset);
        }

        public void onDrawerOpened(View drawerView) {
        }

        public void onDrawerClosed(View drawerView) {
        }

        public void onDrawerStateChanged(int newState) {
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        private List<? extends SearchSuggestion> suggestions = new ArrayList<SearchSuggestion>();
        private boolean isFocused;
        private String query;
        private int queryTextSize;
        private int suggestionTextSize;
        private String searchHint;
        private boolean dismissOnOutsideClick;
        private boolean showMoveSuggestionUpBtn;
        private boolean showSearchKey;
        private boolean isTitleSet;
        private int backgroundColor;
        private int suggestionsTextColor;
        private int queryTextColor;
        private int searchHintTextColor;
        private int actionOverflowMenueColor;
        private int menuItemIconColor;
        private int leftIconColor;
        private int clearBtnColor;
        private int suggestionUpBtnColor;
        private int dividerColor;
        private int menuId;
        private int leftActionMode;
        private boolean dimBackground;
        private long suggestionsSectionAnimSuration;
        private boolean dismissOnSoftKeyboardDismiss;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            in.readList(this.suggestions, ((Object)((Object)this)).getClass().getClassLoader());
            this.isFocused = in.readInt() != 0;
            this.query = in.readString();
            this.queryTextSize = in.readInt();
            this.suggestionTextSize = in.readInt();
            this.searchHint = in.readString();
            this.dismissOnOutsideClick = in.readInt() != 0;
            this.showMoveSuggestionUpBtn = in.readInt() != 0;
            this.showSearchKey = in.readInt() != 0;
            this.isTitleSet = in.readInt() != 0;
            this.backgroundColor = in.readInt();
            this.suggestionsTextColor = in.readInt();
            this.queryTextColor = in.readInt();
            this.searchHintTextColor = in.readInt();
            this.actionOverflowMenueColor = in.readInt();
            this.menuItemIconColor = in.readInt();
            this.leftIconColor = in.readInt();
            this.clearBtnColor = in.readInt();
            this.suggestionUpBtnColor = in.readInt();
            this.dividerColor = in.readInt();
            this.menuId = in.readInt();
            this.leftActionMode = in.readInt();
            this.dimBackground = in.readInt() != 0;
            this.suggestionsSectionAnimSuration = in.readLong();
            this.dismissOnSoftKeyboardDismiss = in.readInt() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeList(this.suggestions);
            out.writeInt(this.isFocused ? 1 : 0);
            out.writeString(this.query);
            out.writeInt(this.queryTextSize);
            out.writeInt(this.suggestionTextSize);
            out.writeString(this.searchHint);
            out.writeInt(this.dismissOnOutsideClick ? 1 : 0);
            out.writeInt(this.showMoveSuggestionUpBtn ? 1 : 0);
            out.writeInt(this.showSearchKey ? 1 : 0);
            out.writeInt(this.isTitleSet ? 1 : 0);
            out.writeInt(this.backgroundColor);
            out.writeInt(this.suggestionsTextColor);
            out.writeInt(this.queryTextColor);
            out.writeInt(this.searchHintTextColor);
            out.writeInt(this.actionOverflowMenueColor);
            out.writeInt(this.menuItemIconColor);
            out.writeInt(this.leftIconColor);
            out.writeInt(this.clearBtnColor);
            out.writeInt(this.suggestionUpBtnColor);
            out.writeInt(this.dividerColor);
            out.writeInt(this.menuId);
            out.writeInt(this.leftActionMode);
            out.writeInt(this.dimBackground ? 1 : 0);
            out.writeLong(this.suggestionsSectionAnimSuration);
            out.writeInt(this.dismissOnSoftKeyboardDismiss ? 1 : 0);
        }
    }

    public static interface OnClearSearchActionListener {
        public void onClearSearchClicked();
    }

    public static interface OnFocusChangeListener {
        public void onFocus();

        public void onFocusCleared();
    }

    public static interface OnMenuItemClickListener {
        public void onActionMenuItemSelected(MenuItem var1);
    }

    public static interface OnHomeActionClickListener {
        public void onHomeClicked();
    }

    public static interface OnLeftMenuClickListener {
        public void onMenuOpened();

        public void onMenuClosed();
    }

    public static interface OnSearchListener {
        public void onSuggestionClicked(SearchSuggestion var1);

        public void onSearchAction(String var1);
    }

    public static interface OnQueryChangeListener {
        public void onSearchTextChanged(String var1, String var2);
    }

    public static interface OnSuggestionsListHeightChanged {
        public void onSuggestionsListHeightChanged(float var1);
    }

    private static interface OnSuggestionSecHeightSetListener {
        public void onSuggestionSecHeightSet();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeftActionMode {
    }
}

