/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview.util.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.util.MenuPopupHelper;
import com.arlib.floatingsearchview.util.Util;
import com.bartoszlipinski.viewpropertyobjectanimator.ViewPropertyObjectAnimator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class MenuView
extends LinearLayout {
    private final int HIDE_IF_ROOM_ITEMS_ANIM_DURATION = 400;
    private final int SHOW_IF_ROOM_ITEMS_ANIM_DURATION = 450;
    private final float ACTION_DIMENSION_PX;
    private int mMenu = -1;
    private MenuBuilder mMenuBuilder;
    private SupportMenuInflater mMenuInflater;
    private MenuPopupHelper mMenuPopupHelper;
    private MenuBuilder.Callback mMenuCallback;
    private int mActionIconColor;
    private int mOverflowIconColor;
    private List<MenuItemImpl> mMenuItems;
    private List<MenuItemImpl> mActionItems = new ArrayList<MenuItemImpl>();
    private List<MenuItemImpl> mActionShowAlwaysItems = new ArrayList<MenuItemImpl>();
    private boolean mHasOverflow = false;
    private OnVisibleWidthChanged mOnVisibleWidthChanged;
    private List<ObjectAnimator> anims = new ArrayList<ObjectAnimator>();

    public MenuView(Context context) {
        this(context, null);
    }

    public MenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ACTION_DIMENSION_PX = context.getResources().getDimension(R.dimen.square_button_size);
        this.init();
    }

    private void init() {
        this.mMenuBuilder = new MenuBuilder(this.getContext());
        this.mMenuPopupHelper = new MenuPopupHelper(this.getContext(), this.mMenuBuilder, (View)this);
        this.mActionIconColor = this.getResources().getColor(R.color.gray_active_icon);
        this.mOverflowIconColor = this.getResources().getColor(R.color.gray_active_icon);
    }

    public void setActionIconColor(int actionColor) {
        this.mActionIconColor = actionColor;
        this.refreshColors();
    }

    public void setOverflowColor(int overflowColor) {
        this.mOverflowIconColor = overflowColor;
        this.refreshColors();
    }

    private void refreshColors() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Util.setIconColor(((ImageView)this.getChildAt(i)).getDrawable(), this.mActionIconColor);
            if (!this.mHasOverflow || i != this.getChildCount() - 1) continue;
            Util.setIconColor(((ImageView)this.getChildAt(i)).getDrawable(), this.mOverflowIconColor);
        }
    }

    public void resetMenuResource(int menu) {
        this.mMenu = menu;
    }

    public void setMenuCallback(MenuBuilder.Callback menuCallback) {
        this.mMenuCallback = menuCallback;
    }

    public void reset(int availWidth) {
        if (this.mMenu == -1) {
            return;
        }
        this.removeAllViews();
        this.mActionItems.clear();
        this.mMenuBuilder.clearAll();
        this.getMenuInflater().inflate(this.mMenu, (Menu)this.mMenuBuilder);
        this.mMenuItems = this.mMenuBuilder.getActionItems();
        this.mMenuItems.addAll(this.mMenuBuilder.getNonActionItems());
        int holdAllItemsCount = this.mMenuItems.size();
        Collections.sort(this.mMenuItems, new Comparator<MenuItemImpl>(){

            @Override
            public int compare(MenuItemImpl lhs, MenuItemImpl rhs) {
                return Integer.valueOf(lhs.getOrder()).compareTo(rhs.getOrder());
            }
        });
        List<MenuItemImpl> menuItems = this.filter(this.mMenuItems, new MenuItemImplPredicate(){

            @Override
            public boolean apply(MenuItemImpl menuItem) {
                return menuItem.requiresActionButton() || menuItem.requestsActionButton();
            }
        });
        int availItemRoom = availWidth / (int)this.ACTION_DIMENSION_PX;
        boolean addOverflowAtTheEnd = false;
        if (menuItems.size() < holdAllItemsCount || availItemRoom < menuItems.size()) {
            addOverflowAtTheEnd = true;
            --availItemRoom;
        }
        ArrayList<Integer> actionMenuItems = new ArrayList<Integer>();
        if (availItemRoom > 0) {
            for (int i = 0; i < menuItems.size(); ++i) {
                final MenuItemImpl menuItem = menuItems.get(i);
                if (menuItem.getIcon() == null) continue;
                ImageView action = this.getActionHolder();
                action.setImageDrawable(Util.setIconColor(menuItem.getIcon(), this.mActionIconColor));
                this.addView((View)action);
                this.mActionItems.add(menuItem);
                action.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MenuView.this.mMenuCallback != null) {
                            MenuView.this.mMenuCallback.onMenuItemSelected(MenuView.this.mMenuBuilder, (MenuItem)menuItem);
                        }
                    }
                });
                actionMenuItems.add(menuItem.getItemId());
                if (--availItemRoom == 0) break;
            }
        }
        if (addOverflowAtTheEnd) {
            ImageView overflowAction = this.getOverflowActionHolder();
            overflowAction.setImageDrawable(Util.setIconColor(this.getResources().getDrawable(R.drawable.ic_more_vert_black_24dp), this.mOverflowIconColor));
            this.addView((View)overflowAction);
            overflowAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MenuView.this.mMenuPopupHelper.show();
                }
            });
            this.mMenuBuilder.setCallback(this.mMenuCallback);
            this.mHasOverflow = true;
        }
        Iterator i$ = actionMenuItems.iterator();
        while (i$.hasNext()) {
            int id2 = (Integer)i$.next();
            this.mMenuBuilder.removeItem(id2);
        }
        actionMenuItems.clear();
        if (this.mOnVisibleWidthChanged != null) {
            this.mOnVisibleWidthChanged.onVisibleWidthChanged((int)this.ACTION_DIMENSION_PX * this.getChildCount() - (this.mHasOverflow ? Util.dpToPx(8) : 0));
        }
    }

    private ImageView getActionHolder() {
        return (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.action_item_layout, (ViewGroup)this, false);
    }

    private ImageView getOverflowActionHolder() {
        return (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.overflow_action_item_layout, (ViewGroup)this, false);
    }

    public void hideIfRoomItems(boolean withAnim) {
        int i;
        int actionItemIndex;
        if (this.mMenu == -1) {
            return;
        }
        this.mActionShowAlwaysItems.clear();
        this.cancelChildAnimListAndClear();
        List<MenuItemImpl> showAlwaysActionItems = this.filter(this.mMenuItems, new MenuItemImplPredicate(){

            @Override
            public boolean apply(MenuItemImpl menuItem) {
                return menuItem.requiresActionButton();
            }
        });
        for (actionItemIndex = 0; actionItemIndex < this.mActionItems.size() && actionItemIndex < showAlwaysActionItems.size(); ++actionItemIndex) {
            final MenuItemImpl actionItem = showAlwaysActionItems.get(actionItemIndex);
            if (this.mActionItems.get(actionItemIndex).getItemId() != showAlwaysActionItems.get(actionItemIndex).getItemId()) {
                ImageView action = (ImageView)this.getChildAt(actionItemIndex);
                action.setImageDrawable(Util.setIconColor(actionItem.getIcon(), this.mActionIconColor));
                action.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MenuView.this.mMenuCallback != null) {
                            MenuView.this.mMenuCallback.onMenuItemSelected(MenuView.this.mMenuBuilder, (MenuItem)actionItem);
                        }
                    }
                });
            }
            this.mActionShowAlwaysItems.add(actionItem);
        }
        int diff = this.mActionItems.size() - actionItemIndex + (this.mHasOverflow ? 1 : 0);
        this.anims = new ArrayList<ObjectAnimator>();
        for (i = 0; i < actionItemIndex; ++i) {
            final View currentChild = this.getChildAt(i);
            final float destTransX = this.ACTION_DIMENSION_PX * (float)diff - (float)(this.mHasOverflow ? Util.dpToPx(8) : 0);
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentChild).setDuration(withAnim ? 400L : 0L).setInterpolator((Interpolator)new AccelerateInterpolator()).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentChild.setTranslationX(destTransX);
                }
            }).translationXBy(destTransX).get());
        }
        for (i = actionItemIndex; i < diff + actionItemIndex; ++i) {
            final View currentView = this.getChildAt(i);
            currentView.setClickable(false);
            if (i != this.getChildCount() - 1) {
                this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).setDuration(withAnim ? 400L : 0L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        currentView.setTranslationX(MenuView.this.ACTION_DIMENSION_PX);
                    }
                }).translationXBy(this.ACTION_DIMENSION_PX).get());
            }
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).setDuration(withAnim ? 400L : 0L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setScaleX(0.5f);
                }
            }).scaleX(0.5f).get());
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).setDuration(withAnim ? 400L : 0L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setScaleY(0.5f);
                }
            }).scaleY(0.5f).get());
            this.anims.add(ViewPropertyObjectAnimator.animate((View)this.getChildAt(i)).setDuration(withAnim ? 400L : 0L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setAlpha(0.0f);
                }
            }).alpha(0.0f).get());
        }
        final int actinItemsCount = actionItemIndex;
        if (!this.anims.isEmpty()) {
            AnimatorSet animSet = new AnimatorSet();
            if (!withAnim) {
                animSet.setDuration(0L);
            }
            animSet.playTogether((Animator[])this.anims.toArray(new ObjectAnimator[this.anims.size()]));
            animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (MenuView.this.mOnVisibleWidthChanged != null) {
                        MenuView.this.mOnVisibleWidthChanged.onVisibleWidthChanged((int)MenuView.this.ACTION_DIMENSION_PX * actinItemsCount);
                    }
                }
            });
            animSet.start();
        }
    }

    public void showIfRoomItems(boolean withAnim) {
        if (this.mMenu == -1) {
            return;
        }
        this.cancelChildAnimListAndClear();
        if (this.mMenuItems.isEmpty()) {
            return;
        }
        this.anims = new ArrayList<ObjectAnimator>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            final View currentView = this.getChildAt(i);
            if (i < this.mActionItems.size()) {
                ImageView action = (ImageView)currentView;
                final MenuItem actionItem = (MenuItem)this.mActionItems.get(i);
                action.setImageDrawable(Util.setIconColor(actionItem.getIcon(), this.mActionIconColor));
                action.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MenuView.this.mMenuCallback != null) {
                            MenuView.this.mMenuCallback.onMenuItemSelected(MenuView.this.mMenuBuilder, actionItem);
                        }
                    }
                });
            }
            int animDuration = withAnim ? 450 : 0;
            DecelerateInterpolator interpolator = new DecelerateInterpolator();
            if (i > this.mActionShowAlwaysItems.size() - 1) {
                interpolator = new LinearInterpolator();
            }
            currentView.setClickable(true);
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setTranslationX(0.0f);
                }
            }).setInterpolator((Interpolator)interpolator).setDuration((long)animDuration).translationX(0.0f).get());
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setScaleX(1.0f);
                }
            }).setInterpolator((Interpolator)interpolator).setDuration((long)animDuration).scaleX(1.0f).get());
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setScaleY(1.0f);
                }
            }).setInterpolator((Interpolator)interpolator).setDuration((long)animDuration).scaleY(1.0f).get());
            this.anims.add(ViewPropertyObjectAnimator.animate((View)currentView).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    currentView.setAlpha(1.0f);
                }
            }).setInterpolator((Interpolator)interpolator).setDuration((long)animDuration).alpha(1.0f).get());
        }
        AnimatorSet animSet = new AnimatorSet();
        if (!withAnim) {
            animSet.setDuration(0L);
        }
        animSet.playTogether((Animator[])this.anims.toArray(new ObjectAnimator[this.anims.size()]));
        animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (MenuView.this.mOnVisibleWidthChanged != null) {
                    MenuView.this.mOnVisibleWidthChanged.onVisibleWidthChanged(MenuView.this.getChildCount() * (int)MenuView.this.ACTION_DIMENSION_PX - (MenuView.this.mHasOverflow ? Util.dpToPx(8) : 0));
                }
            }
        });
        animSet.start();
    }

    private List<MenuItemImpl> filter(List<MenuItemImpl> target, MenuItemImplPredicate predicate) {
        ArrayList<MenuItemImpl> result = new ArrayList<MenuItemImpl>();
        for (MenuItemImpl element : target) {
            if (!predicate.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    private MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.mMenuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.mMenuInflater;
    }

    public void setOnVisibleWidthChanged(OnVisibleWidthChanged listener) {
        this.mOnVisibleWidthChanged = listener;
    }

    private void cancelChildAnimListAndClear() {
        for (ObjectAnimator animator : this.anims) {
            animator.cancel();
        }
        this.anims.clear();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelChildAnimListAndClear();
    }

    private static interface MenuItemImplPredicate {
        public boolean apply(MenuItemImpl var1);
    }

    public static interface OnVisibleWidthChanged {
        public void onVisibleWidthChanged(int var1);
    }
}

