/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.indicator;

import android.content.Context;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import com.github.appintro.indicator.IndicatorController;
import com.github.appintro.internal.LayoutUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\bH\u0016R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/github/appintro/indicator/ProgressIndicatorController;", "Lcom/github/appintro/indicator/IndicatorController;", "Landroid/widget/ProgressBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isRtl", "", "()Z", "value", "selectedIndicatorColor", "getSelectedIndicatorColor", "()I", "setSelectedIndicatorColor", "(I)V", "unselectedIndicatorColor", "getUnselectedIndicatorColor", "setUnselectedIndicatorColor", "initialize", "", "slideCount", "newInstance", "selectPosition", "index", "appintro_release"})
public final class ProgressIndicatorController
extends ProgressBar
implements IndicatorController {
    private int selectedIndicatorColor;
    private int unselectedIndicatorColor;

    @JvmOverloads
    public ProgressIndicatorController(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.selectedIndicatorColor = 1;
        this.unselectedIndicatorColor = 1;
    }

    public /* synthetic */ ProgressIndicatorController(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842872;
        }
        this(context, attributeSet, n);
    }

    @Override
    public int getSelectedIndicatorColor() {
        return this.selectedIndicatorColor;
    }

    @Override
    public void setSelectedIndicatorColor(int value) {
        this.selectedIndicatorColor = value;
        this.getProgressDrawable().setColorFilter(value, PorterDuff.Mode.SRC_IN);
    }

    @Override
    public int getUnselectedIndicatorColor() {
        return this.unselectedIndicatorColor;
    }

    @Override
    public void setUnselectedIndicatorColor(int value) {
        this.unselectedIndicatorColor = value;
        this.getIndeterminateDrawable().setColorFilter(value, PorterDuff.Mode.SRC_IN);
    }

    @NotNull
    public ProgressIndicatorController newInstance(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this;
    }

    @Override
    public void initialize(int slideCount) {
        this.setMax(slideCount);
        if (this.isRtl()) {
            this.setScaleX(-1.0f);
        }
        if (slideCount == 1) {
            this.setVisibility(4);
        }
        this.selectPosition(0);
    }

    @Override
    public void selectPosition(int index) {
        this.setProgress(this.isRtl() ? this.getMax() - index : index + 1);
    }

    private final boolean isRtl() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
        return LayoutUtil.isRtl(context);
    }

    @JvmOverloads
    public ProgressIndicatorController(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ProgressIndicatorController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

