/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import com.github.paolorotolo.appintro.ISlideBackgroundColorHolder;
import com.github.paolorotolo.appintro.ISlideSelectionListener;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.internal.LogHelper;
import com.github.paolorotolo.appintro.internal.TypefaceContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J&\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001dH\u0016J\b\u0010'\u001a\u00020\u001bH\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\u0012\u0010)\u001a\u00020\u001b2\b\b\u0001\u0010*\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\b8eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/github/paolorotolo/appintro/AppIntroBaseFragment;", "Landroidx/fragment/app/Fragment;", "Lcom/github/paolorotolo/appintro/ISlideSelectionListener;", "Lcom/github/paolorotolo/appintro/ISlideBackgroundColorHolder;", "()V", "TAG", "", "bgDrawable", "", "defaultBackgroundColor", "getDefaultBackgroundColor", "()I", "setDefaultBackgroundColor", "(I)V", "descColor", "descTypeface", "Lcom/github/paolorotolo/appintro/internal/TypefaceContainer;", "description", "drawable", "layoutId", "getLayoutId", "mainLayout", "Landroidx/constraintlayout/widget/ConstraintLayout;", "title", "titleColor", "titleTypeface", "onActivityCreated", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreate", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onSaveInstanceState", "outState", "onSlideDeselected", "onSlideSelected", "setBackgroundColor", "backgroundColor", "appintro_release"})
public abstract class AppIntroBaseFragment
extends Fragment
implements ISlideSelectionListener,
ISlideBackgroundColorHolder {
    private final String TAG = LogHelper.makeLogTag(AppIntroBaseFragment.class);
    private int drawable;
    private int bgDrawable;
    private int titleColor;
    private int descColor;
    private int defaultBackgroundColor;
    private String title;
    private String description;
    private TypefaceContainer titleTypeface;
    private TypefaceContainer descTypeface;
    private ConstraintLayout mainLayout;

    @LayoutRes
    protected abstract int getLayoutId();

    @Override
    public int getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(int n) {
        this.defaultBackgroundColor = n;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        Bundle args = this.getArguments();
        if (args != null && args.size() != 0) {
            this.drawable = args.getInt("drawable");
            this.title = args.getString("title");
            this.description = args.getString("desc");
            this.bgDrawable = args.getInt("bg_drawable");
            String argsTitleTypeface = args.getString("title_typeface");
            String argsDescTypeface = args.getString("desc_typeface");
            int argsTitleTypefaceRes = args.getInt("title_typeface_res");
            int argsDescTypefaceRes = args.getInt("desc_typeface_res");
            this.titleTypeface = new TypefaceContainer(argsTitleTypeface, argsTitleTypefaceRes);
            this.descTypeface = new TypefaceContainer(argsDescTypeface, argsDescTypefaceRes);
            this.setDefaultBackgroundColor(args.getInt("bg_color"));
            this.titleColor = args.getInt("title_color", 0);
            this.descColor = args.getInt("desc_color", 0);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.drawable = savedInstanceState.getInt("drawable");
            this.title = savedInstanceState.getString("title");
            this.description = savedInstanceState.getString("desc");
            this.titleTypeface = new TypefaceContainer(savedInstanceState.getString("title_typeface"), savedInstanceState.getInt("title_typeface_res", 0));
            this.descTypeface = new TypefaceContainer(savedInstanceState.getString("desc_typeface"), savedInstanceState.getInt("desc_typeface_res", 0));
            this.setDefaultBackgroundColor(savedInstanceState.getInt("bg_color"));
            this.bgDrawable = savedInstanceState.getInt("bg_drawable");
            this.titleColor = savedInstanceState.getInt("title_color");
            this.descColor = savedInstanceState.getInt("desc_color");
        }
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
                view = inflater.inflate(this.getLayoutId(), container, false);
                TextView titleText = (TextView)view.findViewById(R.id.title);
                TextView descriptionText = (TextView)view.findViewById(R.id.description);
                ImageView slideImage = (ImageView)view.findViewById(R.id.image);
                this.mainLayout = (ConstraintLayout)view.findViewById(R.id.main);
                TextView textView = titleText;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"titleText");
                textView.setText((CharSequence)this.title);
                TextView textView2 = descriptionText;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"descriptionText");
                textView2.setText((CharSequence)this.description);
                if (this.titleColor != 0) {
                    titleText.setTextColor(this.titleColor);
                }
                if (this.descColor != 0) {
                    descriptionText.setTextColor(this.descColor);
                }
                TypefaceContainer typefaceContainer = this.titleTypeface;
                if (typefaceContainer != null) {
                    typefaceContainer.applyTo(titleText);
                }
                TypefaceContainer typefaceContainer2 = this.descTypeface;
                if (typefaceContainer2 != null) {
                    typefaceContainer2.applyTo(descriptionText);
                }
                slideImage.setImageResource(this.drawable);
                if (this.bgDrawable == 0) break block4;
                ConstraintLayout constraintLayout = this.mainLayout;
                if (constraintLayout == null) break block5;
                constraintLayout.setBackgroundResource(this.bgDrawable);
                break block5;
            }
            ConstraintLayout constraintLayout = this.mainLayout;
            if (constraintLayout == null) break block5;
            constraintLayout.setBackgroundColor(this.getDefaultBackgroundColor());
        }
        return view;
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        outState.putInt("drawable", this.drawable);
        outState.putInt("bg_drawable", this.bgDrawable);
        outState.putString("title", this.title);
        outState.putString("desc", this.description);
        outState.putInt("bg_color", this.getDefaultBackgroundColor());
        outState.putInt("title_color", this.titleColor);
        outState.putInt("desc_color", this.descColor);
        if (this.titleTypeface != null) {
            TypefaceContainer typefaceContainer = this.titleTypeface;
            outState.putString("title_typeface", typefaceContainer != null ? typefaceContainer.getTypeFaceUrl() : null);
            TypefaceContainer typefaceContainer2 = this.titleTypeface;
            outState.putInt("title_typeface_res", typefaceContainer2 != null ? typefaceContainer2.getTypeFaceResource() : 0);
        }
        if (this.descTypeface != null) {
            TypefaceContainer typefaceContainer = this.descTypeface;
            outState.putString("desc_typeface", typefaceContainer != null ? typefaceContainer.getTypeFaceUrl() : null);
            TypefaceContainer typefaceContainer3 = this.descTypeface;
            outState.putInt("desc_typeface_res", typefaceContainer3 != null ? typefaceContainer3.getTypeFaceResource() : 0);
        }
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onSlideDeselected() {
        LogHelper.d(this.TAG, "Slide " + this.title + " has been deselected.");
    }

    @Override
    public void onSlideSelected() {
        LogHelper.d(this.TAG, "Slide " + this.title + " has been selected.");
    }

    @Override
    public void setBackgroundColor(@ColorInt int backgroundColor) {
        block0: {
            ConstraintLayout constraintLayout = this.mainLayout;
            if (constraintLayout == null) break block0;
            constraintLayout.setBackgroundColor(backgroundColor);
        }
    }
}

