package com.github.apetrelli.gwtintegration.util.shared;

public class StringUtils {

	private StringUtils() {}
	
    /**
     * Got from Apache Commons Lang.
     * 
     * <p>Checks if a String is whitespace, empty ("") or null.</p>
     *
     * <pre>
     * StringUtils.isBlank(null)      = true
     * StringUtils.isBlank("")        = true
     * StringUtils.isBlank(" ")       = true
     * StringUtils.isBlank("bob")     = false
     * StringUtils.isBlank("  bob  ") = false
     * </pre>
     *
     * @param str  the String to check, may be null
     * @return <code>true</code> if the String is null, empty or whitespace
     * @since 2.0
     */
    @SuppressWarnings("deprecation")
	public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; i++) {
            if ((Character.isSpace(str.charAt(i)) == false)) {
                return false;
            }
        }
        return true;
    }
}
