/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.avro.io.Decoder;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Types;

class GenericReaders {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericReaders() {
    }

    static ValueReader<LocalDate> dates() {
        return DateReader.INSTANCE;
    }

    static ValueReader<LocalTime> times() {
        return TimeReader.INSTANCE;
    }

    static ValueReader<LocalDateTime> timestamps() {
        return TimestampReader.INSTANCE;
    }

    static ValueReader<OffsetDateTime> timestamptz() {
        return TimestamptzReader.INSTANCE;
    }

    static ValueReader<Record> struct(Types.StructType struct, List<ValueReader<?>> readers) {
        return new GenericRecordReader(readers, struct);
    }

    private static class GenericRecordReader
    extends ValueReaders.StructReader<Record> {
        private final Types.StructType structType;

        private GenericRecordReader(List<ValueReader<?>> readers, Types.StructType struct) {
            super(readers);
            this.structType = struct;
        }

        protected Record reuseOrCreate(Object reuse) {
            if (reuse instanceof Record) {
                return (Record)reuse;
            }
            return GenericRecord.create(this.structType);
        }

        protected Object get(Record struct, int pos) {
            return struct.get(pos);
        }

        protected void set(Record struct, int pos, Object value) {
            struct.set(pos, value);
        }
    }

    private static class TimestamptzReader
    implements ValueReader<OffsetDateTime> {
        private static final TimestamptzReader INSTANCE = new TimestamptzReader();

        private TimestamptzReader() {
        }

        public OffsetDateTime read(Decoder decoder, Object reuse) throws IOException {
            return EPOCH.plus(decoder.readLong(), ChronoUnit.MICROS);
        }
    }

    private static class TimestampReader
    implements ValueReader<LocalDateTime> {
        private static final TimestampReader INSTANCE = new TimestampReader();

        private TimestampReader() {
        }

        public LocalDateTime read(Decoder decoder, Object reuse) throws IOException {
            return EPOCH.plus(decoder.readLong(), ChronoUnit.MICROS).toLocalDateTime();
        }
    }

    private static class TimeReader
    implements ValueReader<LocalTime> {
        private static final TimeReader INSTANCE = new TimeReader();

        private TimeReader() {
        }

        public LocalTime read(Decoder decoder, Object reuse) throws IOException {
            return LocalTime.ofNanoOfDay(decoder.readLong() * 1000L);
        }
    }

    private static class DateReader
    implements ValueReader<LocalDate> {
        private static final DateReader INSTANCE = new DateReader();

        private DateReader() {
        }

        public LocalDate read(Decoder decoder, Object reuse) throws IOException {
            return EPOCH_DAY.plusDays(decoder.readInt());
        }
    }
}

