/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UnicodeUtil;

public class Comparators {
    private static final ImmutableMap<Type.PrimitiveType, Comparator<?>> COMPARATORS = ImmutableMap.builder().put((Object)Types.BooleanType.get(), Comparator.naturalOrder()).put((Object)Types.IntegerType.get(), Comparator.naturalOrder()).put((Object)Types.LongType.get(), Comparator.naturalOrder()).put((Object)Types.FloatType.get(), Comparator.naturalOrder()).put((Object)Types.DoubleType.get(), Comparator.naturalOrder()).put((Object)Types.DateType.get(), Comparator.naturalOrder()).put((Object)Types.TimeType.get(), Comparator.naturalOrder()).put((Object)Types.TimestampType.withZone(), Comparator.naturalOrder()).put((Object)Types.TimestampType.withoutZone(), Comparator.naturalOrder()).put((Object)Types.StringType.get(), Comparators.charSequences()).put((Object)Types.UUIDType.get(), Comparator.naturalOrder()).put((Object)Types.BinaryType.get(), Comparators.unsignedBytes()).build();

    private Comparators() {
    }

    public static <T> Comparator<T> forType(Type.PrimitiveType type) {
        Comparator cmp = (Comparator)COMPARATORS.get((Object)type);
        if (cmp != null) {
            return cmp;
        }
        if (type instanceof Types.FixedType) {
            return Comparators.unsignedBytes();
        }
        if (type instanceof Types.DecimalType) {
            return Comparator.naturalOrder();
        }
        throw new UnsupportedOperationException("Cannot determine comparator for type: " + type);
    }

    public static Comparator<ByteBuffer> unsignedBytes() {
        return UnsignedByteBufComparator.INSTANCE;
    }

    public static Comparator<ByteBuffer> signedBytes() {
        return Comparator.naturalOrder();
    }

    public static <T> Comparator<T> nullsFirst() {
        return NullsFirst.INSTANCE;
    }

    public static <T> Comparator<T> nullsLast() {
        return NullsLast.INSTANCE;
    }

    public static Comparator<CharSequence> charSequences() {
        return CharSeqComparator.INSTANCE;
    }

    private static class CharSeqComparator
    implements Comparator<CharSequence> {
        private static final CharSeqComparator INSTANCE = new CharSeqComparator();

        private CharSeqComparator() {
        }

        @Override
        public int compare(CharSequence s1, CharSequence s2) {
            int len = Math.min(s1.length(), s2.length());
            for (int i = 0; i < len; ++i) {
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(i);
                boolean isC1HighSurrogate = UnicodeUtil.isCharHighSurrogate(c1);
                boolean isC2HighSurrogate = UnicodeUtil.isCharHighSurrogate(c2);
                if (isC1HighSurrogate && !isC2HighSurrogate) {
                    return 1;
                }
                if (!isC1HighSurrogate && isC2HighSurrogate) {
                    return -1;
                }
                int cmp = Character.compare(c1, c2);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(s1.length(), s2.length());
        }
    }

    private static class UnsignedByteBufComparator
    implements Comparator<ByteBuffer> {
        private static final UnsignedByteBufComparator INSTANCE = new UnsignedByteBufComparator();

        private UnsignedByteBufComparator() {
        }

        @Override
        public int compare(ByteBuffer buf1, ByteBuffer buf2) {
            int len = Math.min(buf1.remaining(), buf2.remaining());
            int b1pos = buf1.position();
            int b2pos = buf2.position();
            for (int i = 0; i < len; ++i) {
                int cmp = Integer.compare(buf1.get(b1pos + i) & 0xFF, buf2.get(b2pos + i) & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(buf1.remaining(), buf2.remaining());
        }
    }

    private static class NullSafeChainedComparator<T>
    implements Comparator<T> {
        private final Comparator<T> first;
        private final Comparator<? super T> second;

        NullSafeChainedComparator(Comparator<T> first, Comparator<? super T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compare(T o1, T o2) {
            int cmp = this.first.compare(o1, o2);
            if (cmp == 0 && o1 != null) {
                return this.second.compare(o1, o2);
            }
            return cmp;
        }
    }

    private static class NullsLast<T>
    implements Comparator<T> {
        private static final NullsLast<?> INSTANCE = new NullsLast();

        private NullsLast() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return -1;
            }
            if (o2 != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullSafeChainedComparator<T>(this, other);
        }
    }

    private static class NullsFirst<T>
    implements Comparator<T> {
        private static final NullsFirst<?> INSTANCE = new NullsFirst();

        private NullsFirst() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return 1;
            }
            if (o2 != null) {
                return -1;
            }
            return 0;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullSafeChainedComparator<T>(this, other);
        }
    }
}

