/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;

public class BoundUnaryPredicate<T>
extends BoundPredicate<T> {
    BoundUnaryPredicate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    @Override
    public boolean isUnaryPredicate() {
        return true;
    }

    @Override
    public BoundUnaryPredicate<T> asUnaryPredicate() {
        return this;
    }

    @Override
    public boolean test(T value) {
        switch (this.op()) {
            case IS_NULL: {
                return value == null;
            }
            case NOT_NULL: {
                return value != null;
            }
        }
        throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + (Object)((Object)this.op()));
    }

    public String toString() {
        switch (this.op()) {
            case IS_NULL: {
                return "is_null(" + this.term() + ")";
            }
            case NOT_NULL: {
                return "not_null(" + this.term() + ")";
            }
        }
        return "Invalid unary predicate: operation = " + (Object)((Object)this.op());
    }
}

