/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Literal;

public class BoundLiteralPredicate<T>
extends BoundPredicate<T> {
    private final Literal<T> literal;

    BoundLiteralPredicate(Expression.Operation op, BoundTerm<T> term, Literal<T> lit) {
        super(op, term);
        Preconditions.checkArgument((op != Expression.Operation.IN && op != Expression.Operation.NOT_IN ? 1 : 0) != 0, (String)"Bound literal predicate does not support operation: %s", (Object)((Object)op));
        this.literal = lit;
    }

    public Literal<T> literal() {
        return this.literal;
    }

    @Override
    public boolean isLiteralPredicate() {
        return true;
    }

    @Override
    public BoundLiteralPredicate<T> asLiteralPredicate() {
        return this;
    }

    @Override
    public boolean test(T value) {
        Comparator<T> cmp = this.literal.comparator();
        switch (this.op()) {
            case LT: {
                return cmp.compare(value, this.literal.value()) < 0;
            }
            case LT_EQ: {
                return cmp.compare(value, this.literal.value()) <= 0;
            }
            case GT: {
                return cmp.compare(value, this.literal.value()) > 0;
            }
            case GT_EQ: {
                return cmp.compare(value, this.literal.value()) >= 0;
            }
            case EQ: {
                return cmp.compare(value, this.literal.value()) == 0;
            }
            case NOT_EQ: {
                return cmp.compare(value, this.literal.value()) != 0;
            }
            case STARTS_WITH: {
                return String.valueOf(value).startsWith((String)this.literal.value());
            }
        }
        throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + (Object)((Object)this.op()));
    }

    public String toString() {
        switch (this.op()) {
            case LT: {
                return this.term() + " < " + this.literal;
            }
            case LT_EQ: {
                return this.term() + " <= " + this.literal;
            }
            case GT: {
                return this.term() + " > " + this.literal;
            }
            case GT_EQ: {
                return this.term() + " >= " + this.literal;
            }
            case EQ: {
                return this.term() + " == " + this.literal;
            }
            case NOT_EQ: {
                return this.term() + " != " + this.literal;
            }
            case STARTS_WITH: {
                return this.term() + " startsWith \"" + this.literal + "\"";
            }
            case IN: {
                return this.term() + " in { " + this.literal + " }";
            }
            case NOT_IN: {
                return this.term() + " not in { " + this.literal + " }";
            }
        }
        return "Invalid literal predicate: operation = " + (Object)((Object)this.op());
    }
}

