/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;

public interface Catalog {
    public List<TableIdentifier> listTables(Namespace var1);

    public Table createTable(TableIdentifier var1, Schema var2, PartitionSpec var3, String var4, Map<String, String> var5);

    default public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, Map<String, String> properties) {
        return this.createTable(identifier, schema, spec, null, properties);
    }

    default public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec) {
        return this.createTable(identifier, schema, spec, null, null);
    }

    default public Table createTable(TableIdentifier identifier, Schema schema) {
        return this.createTable(identifier, schema, PartitionSpec.unpartitioned(), null, null);
    }

    public Transaction newCreateTableTransaction(TableIdentifier var1, Schema var2, PartitionSpec var3, String var4, Map<String, String> var5);

    default public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, Map<String, String> properties) {
        return this.newCreateTableTransaction(identifier, schema, spec, null, properties);
    }

    default public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec) {
        return this.newCreateTableTransaction(identifier, schema, spec, null, null);
    }

    default public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema) {
        return this.newCreateTableTransaction(identifier, schema, PartitionSpec.unpartitioned(), null, null);
    }

    public Transaction newReplaceTableTransaction(TableIdentifier var1, Schema var2, PartitionSpec var3, String var4, Map<String, String> var5, boolean var6);

    default public Transaction newReplaceTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, Map<String, String> properties, boolean orCreate) {
        return this.newReplaceTableTransaction(identifier, schema, spec, null, properties, orCreate);
    }

    default public Transaction newReplaceTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, boolean orCreate) {
        return this.newReplaceTableTransaction(identifier, schema, spec, null, null, orCreate);
    }

    default public Transaction newReplaceTableTransaction(TableIdentifier identifier, Schema schema, boolean orCreate) {
        return this.newReplaceTableTransaction(identifier, schema, PartitionSpec.unpartitioned(), null, null, orCreate);
    }

    default public boolean tableExists(TableIdentifier identifier) {
        try {
            this.loadTable(identifier);
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    default public boolean dropTable(TableIdentifier identifier) {
        return this.dropTable(identifier, true);
    }

    public boolean dropTable(TableIdentifier var1, boolean var2);

    public void renameTable(TableIdentifier var1, TableIdentifier var2);

    public Table loadTable(TableIdentifier var1);
}

