/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class ChildContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean startFromParentLocation;
    private boolean reverse;
    private NodeIterator iterator;

    public ChildContext(EvalContext parentContext, NodeTest nodeTest, boolean startFromParentLocation, boolean reverse) {
        super(parentContext);
        this.nodeTest = nodeTest;
        this.startFromParentLocation = startFromParentLocation;
        this.reverse = reverse;
    }

    @Override
    public NodePointer getCurrentNodePointer() {
        if (this.position == 0 && !this.setPosition(1)) {
            return null;
        }
        return this.iterator == null ? null : this.iterator.getNodePointer();
    }

    @Override
    public Pointer getSingleNodePointer() {
        if (this.position == 0) {
            while (this.nextSet()) {
                this.prepare();
                if (this.iterator == null) {
                    return null;
                }
                NodePointer pointer = this.iterator.getNodePointer();
                if (pointer == null) continue;
                return pointer;
            }
            return null;
        }
        return this.getCurrentNodePointer();
    }

    @Override
    public boolean nextNode() {
        return this.setPosition(this.getCurrentPosition() + 1);
    }

    @Override
    public void reset() {
        super.reset();
        this.iterator = null;
    }

    @Override
    public boolean setPosition(int position) {
        int oldPosition = this.getCurrentPosition();
        super.setPosition(position);
        if (oldPosition == 0) {
            this.prepare();
        }
        return this.iterator == null ? false : this.iterator.setPosition(position);
    }

    private void prepare() {
        NodePointer useParent;
        NodePointer parent = this.parentContext.getCurrentNodePointer();
        if (parent == null) {
            return;
        }
        NodePointer nodePointer = useParent = this.startFromParentLocation ? parent.getParent() : parent;
        this.iterator = useParent == null ? null : useParent.childIterator(this.nodeTest, this.reverse, this.startFromParentLocation ? parent : null);
    }
}

