/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.lands.api;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.angeschossen.lands.api.HolderType;
import me.angeschossen.lands.api.events.LandChatEvent;
import me.angeschossen.lands.api.holders.BalanceHolder;
import me.angeschossen.lands.api.inbox.InboxCategory;
import me.angeschossen.lands.api.inbox.InboxMessage;
import me.angeschossen.lands.api.levels.Level;
import me.angeschossen.lands.api.player.LandPlayer;
import me.angeschossen.lands.api.war.War;
import me.angeschossen.lands.api.war.WarStats;
import me.angeschossen.lands.api.war.enums.WarTeam;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MemberHolder
extends BalanceHolder {
    @Override
    @NotNull
    public String getName();

    @NotNull
    public String getColorName();

    public int getChunksAmount();

    @Nullable
    public War getWar();

    @Nullable
    public Color getWebMapColor();

    @NotNull
    public Collection<? extends LandPlayer> getOnlineLandPlayers();

    @NotNull
    public UUID getOwnerUID();

    @NotNull
    public Collection<Player> getOnlinePlayers();

    public boolean isTrusted(@NotNull UUID var1);

    public int getId();

    public boolean exists();

    public void sendMessage(@NotNull UUID var1, @NotNull String var2, LandChatEvent.MessageSource var3);

    public HolderType getType();

    @NotNull
    public Level getLevel();

    public CompletableFuture<Float> modifyRequirementCache(@NotNull String var1, float var2, boolean var3);

    public boolean isRequirementCached(@NotNull String var1);

    public float getCachedRequirement(@NotNull String var1);

    public void markLevelUpdate();

    @Nullable
    public WarTeam getWarTeam();

    public boolean leaveWar();

    public void addWarshield(long var1);

    public boolean hasWarshield();

    public long getWarshield();

    public boolean hasWarEntity(@NotNull MemberHolder var1);

    public boolean isInWar();

    public boolean isWarField();

    @NotNull
    public Collection<UUID> getTrustedPlayers();

    @Override
    public String getWarName();

    public int getMembersAmount();

    @NotNull
    public List<? extends InboxMessage> getInbox();

    @NotNull
    public List<? extends InboxMessage> getInbox(InboxCategory var1);

    @NotNull
    public WarStats getStats();

    public void updateRequirementCache(@NotNull String var1, float var2, boolean var3) throws IllegalArgumentException;
}

