/*
 * Decompiled with CFR 0.152.
 */
package com.angcyo.tablayout;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u001a \u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0000\u001a \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001aD\u0010 \u001a\u00020!*\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020\u0005H\u0000\u001a\u0016\u0010)\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010*\u001a\u00020\u0005H\u0000\u001a\"\u0010+\u001a\u00020,*\u00020\b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010.\u001a\u00020,H\u0000\u001a\u0016\u0010/\u001a\u00020,*\u00020\b2\b\b\u0002\u0010.\u001a\u00020,H\u0000\u001a&\u0010/\u001a\u00020,*\u00020\b2\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\b\b\u0002\u0010.\u001a\u00020,H\u0000\u001a\u0014\u00102\u001a\u000203*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a \u00104\u001a\u00020\b*\u0002052\b\b\u0001\u00106\u001a\u00020\u00052\b\b\u0002\u00107\u001a\u000203H\u0000\u001a*\u00108\u001a\u000203\"\u0004\b\u0000\u00109*\n\u0012\u0004\u0012\u0002H9\u0018\u00010:2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u0002H9\u0018\u00010:H\u0000\u001a\n\u0010<\u001a\u000203*\u00020\u0005\u001a\n\u0010=\u001a\u000203*\u00020\u0005\u001a\f\u0010>\u001a\u00020?*\u00020@H\u0000\u001a\f\u0010A\u001a\u00020?*\u00020@H\u0000\u001a\f\u0010B\u001a\u00020?*\u00020@H\u0000\u001a\u0014\u0010C\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u0005*\b\u0012\u0002\b\u0003\u0018\u00010D\u001a\u000e\u0010E\u001a\u00020\u0001*\u0004\u0018\u00010FH\u0000\u001a\u0018\u0010G\u001a\u00020\u0001*\u0004\u0018\u00010F2\b\u0010H\u001a\u0004\u0018\u00010#H\u0000\u001a\u0018\u0010I\u001a\u0004\u0018\u00010J*\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020\u0005H\u0000\u001a\u0016\u0010I\u001a\u00020?*\u0004\u0018\u00010\b2\u0006\u0010K\u001a\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\"\u0018\u0010\n\u001a\u00020\u0005*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\u0005*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\"\u0018\u0010\u000e\u001a\u00020\u0005*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0018\u0010\u0010\u001a\u00020\u0005*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006L"}, d2={"dp", "", "getDp", "()F", "dpi", "", "getDpi", "()I", "Landroid/view/View;", "(Landroid/view/View;)I", "screenHeight", "getScreenHeight", "screenWidth", "getScreenWidth", "viewDrawHeight", "getViewDrawHeight", "viewDrawWidth", "getViewDrawWidth", "atmostMeasure", "size", "clamp", "value", "min", "max", "evaluateColor", "fraction", "startColor", "endColor", "exactlyMeasure", "navBarHeight", "context", "Landroid/content/Context;", "calcLayoutWidthHeight", "", "rLayoutWidth", "", "rLayoutHeight", "parentWidth", "parentHeight", "rLayoutWidthExclude", "rLayoutHeightExclude", "getChildOrNull", "index", "getLocationInParent", "Landroid/graphics/Rect;", "parentView", "result", "getViewRect", "offsetX", "offsetY", "have", "", "inflate", "Landroid/view/ViewGroup;", "layoutId", "attachToRoot", "isChange", "T", "", "other", "isHorizontal", "isVertical", "loge", "", "", "logi", "logw", "remove", "", "textHeight", "Landroid/graphics/Paint;", "textWidth", "text", "tintDrawableColor", "Landroid/graphics/drawable/Drawable;", "color", "TabLayout_release"})
public final class LibExKt {
    public static final int getDpi() {
        return (int)LibExKt.getDp();
    }

    public static final float getDp() {
        return Resources.getSystem().getDisplayMetrics().density;
    }

    public static final int getDpi(@NotNull View $this$dpi) {
        Intrinsics.checkNotNullParameter((Object)$this$dpi, (String)"<this>");
        return (int)$this$dpi.getContext().getResources().getDisplayMetrics().density;
    }

    public static final int getScreenWidth(@NotNull View $this$screenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"<this>");
        return $this$screenWidth.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    public static final int getScreenHeight(@NotNull View $this$screenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"<this>");
        return $this$screenHeight.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public static final int getViewDrawWidth(@NotNull View $this$viewDrawWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$viewDrawWidth, (String)"<this>");
        return $this$viewDrawWidth.getMeasuredWidth() - $this$viewDrawWidth.getPaddingLeft() - $this$viewDrawWidth.getPaddingRight();
    }

    public static final int getViewDrawHeight(@NotNull View $this$viewDrawHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$viewDrawHeight, (String)"<this>");
        return $this$viewDrawHeight.getMeasuredHeight() - $this$viewDrawHeight.getPaddingTop() - $this$viewDrawHeight.getPaddingBottom();
    }

    public static final int exactlyMeasure(int size) {
        return View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
    }

    public static final int exactlyMeasure(float size) {
        return LibExKt.exactlyMeasure((int)size);
    }

    public static final int atmostMeasure(int size) {
        return View.MeasureSpec.makeMeasureSpec((int)size, (int)Integer.MIN_VALUE);
    }

    public static final boolean have(int $this$have, int value) {
        return $this$have == 0 || value == 0 ? false : ($this$have == 0 && value == 0 ? true : ($this$have > 0 && value > 0 || $this$have < 0 && value < 0) && ($this$have & value) == value);
    }

    public static final int remove(int $this$remove, int value) {
        return $this$remove & ~value;
    }

    public static final float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final void logi(@NotNull Object $this$logi) {
        Intrinsics.checkNotNullParameter((Object)$this$logi, (String)"<this>");
        Log.i((String)"DslTabLayout", (String)String.valueOf($this$logi));
    }

    public static final void logw(@NotNull Object $this$logw) {
        Intrinsics.checkNotNullParameter((Object)$this$logw, (String)"<this>");
        Log.w((String)"DslTabLayout", (String)String.valueOf($this$logw));
    }

    public static final void loge(@NotNull Object $this$loge) {
        Intrinsics.checkNotNullParameter((Object)$this$loge, (String)"<this>");
        Log.e((String)"DslTabLayout", (String)String.valueOf($this$loge));
    }

    @NotNull
    public static final int[] calcLayoutWidthHeight(@NotNull View $this$calcLayoutWidthHeight, @Nullable String rLayoutWidth, @Nullable String rLayoutHeight, int parentWidth, int parentHeight, int rLayoutWidthExclude, int rLayoutHeightExclude) {
        int[] size;
        block8: {
            float it;
            Float ratio;
            block9: {
                Intrinsics.checkNotNullParameter((Object)$this$calcLayoutWidthHeight, (String)"<this>");
                int[] nArray = new int[]{-1, -1};
                size = nArray;
                if (TextUtils.isEmpty((CharSequence)rLayoutWidth) && TextUtils.isEmpty((CharSequence)rLayoutHeight)) {
                    return size;
                }
                if (!TextUtils.isEmpty((CharSequence)rLayoutWidth)) {
                    String string = rLayoutWidth;
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.contains((CharSequence)string, (CharSequence)"sw", (boolean)true)) {
                        Float f = ratio = StringsKt.toFloatOrNull((String)StringsKt.replace((String)rLayoutWidth, (String)"sw", (String)"", (boolean)true));
                        if (f != null) {
                            it = ((Number)f).floatValue();
                            boolean bl = false;
                            size[0] = (int)(ratio.floatValue() * (float)(LibExKt.getScreenWidth($this$calcLayoutWidthHeight) - rLayoutWidthExclude));
                        }
                    } else if (StringsKt.contains((CharSequence)rLayoutWidth, (CharSequence)"pw", (boolean)true)) {
                        Float f = ratio = StringsKt.toFloatOrNull((String)StringsKt.replace((String)rLayoutWidth, (String)"pw", (String)"", (boolean)true));
                        if (f != null) {
                            it = ((Number)f).floatValue();
                            boolean bl = false;
                            size[0] = (int)(ratio.floatValue() * (float)(parentWidth - rLayoutWidthExclude));
                        }
                    }
                }
                if (TextUtils.isEmpty((CharSequence)rLayoutHeight)) break block8;
                String string = rLayoutHeight;
                Intrinsics.checkNotNull((Object)string);
                if (!StringsKt.contains((CharSequence)string, (CharSequence)"sh", (boolean)true)) break block9;
                Float f = ratio = StringsKt.toFloatOrNull((String)StringsKt.replace((String)rLayoutHeight, (String)"sh", (String)"", (boolean)true));
                if (f == null) break block8;
                it = ((Number)f).floatValue();
                boolean bl = false;
                size[1] = (int)(ratio.floatValue() * (float)(LibExKt.getScreenHeight($this$calcLayoutWidthHeight) - rLayoutHeightExclude));
                break block8;
            }
            if (!StringsKt.contains((CharSequence)rLayoutHeight, (CharSequence)"ph", (boolean)true)) break block8;
            Float f = ratio = StringsKt.toFloatOrNull((String)StringsKt.replace((String)rLayoutHeight, (String)"ph", (String)"", (boolean)true));
            if (f != null) {
                it = ((Number)f).floatValue();
                boolean bl = false;
                size[1] = (int)(ratio.floatValue() * (float)(parentHeight - rLayoutHeightExclude));
            }
        }
        return size;
    }

    public static /* synthetic */ int[] calcLayoutWidthHeight$default(View view, String string, String string2, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 0;
        }
        return LibExKt.calcLayoutWidthHeight(view, string, string2, n, n2, n3, n4);
    }

    public static final int evaluateColor(float fraction, int startColor, int endColor) {
        float fr = MathUtils.clamp((float)fraction, (float)0.0f, (float)1.0f);
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        return startA + (int)(fr * (float)(endA - startA)) << 24 | startR + (int)(fr * (float)(endR - startR)) << 16 | startG + (int)(fr * (float)(endG - startG)) << 8 | startB + (int)(fr * (float)(endB - startB));
    }

    @Nullable
    public static final Drawable tintDrawableColor(@Nullable Drawable $this$tintDrawableColor, int color) {
        if ($this$tintDrawableColor == null) {
            return $this$tintDrawableColor;
        }
        Drawable drawable2 = DrawableCompat.wrap((Drawable)$this$tintDrawableColor).mutate();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"wrap(this).mutate()");
        Drawable wrappedDrawable = drawable2;
        if (Build.VERSION.SDK_INT >= 21) {
            DrawableCompat.setTint((Drawable)wrappedDrawable, (int)color);
        } else {
            wrappedDrawable.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
        }
        return wrappedDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public static final void tintDrawableColor(@Nullable View $this$tintDrawableColor, int color) {
        View view = $this$tintDrawableColor;
        if (view instanceof TextView) {
            Drawable[] drawables = new Drawable[4];
            Drawable[] drawableArray = ((TextView)$this$tintDrawableColor).getCompoundDrawables();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawables");
            Object[] $this$forEachIndexed$iv = drawableArray;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void drawable2;
                int n = index$iv++;
                Drawable drawable3 = (Drawable)item$iv;
                int index = n;
                boolean bl = false;
                void v2 = drawable2;
                drawables[index] = v2 != null ? LibExKt.tintDrawableColor((Drawable)v2, color) : null;
            }
            ((TextView)$this$tintDrawableColor).setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);
        } else if (view instanceof ImageView) {
            Drawable drawable4 = ((ImageView)$this$tintDrawableColor).getDrawable();
            ((ImageView)$this$tintDrawableColor).setImageDrawable((Drawable)(drawable4 != null ? LibExKt.tintDrawableColor(drawable4, color) : null));
        }
    }

    public static final float textWidth(@Nullable Paint $this$textWidth, @Nullable String text) {
        float f;
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 0.0f;
        }
        Paint paint = $this$textWidth;
        if (paint != null) {
            Paint $this$textWidth_u24lambda_u245 = paint;
            boolean bl = false;
            f = $this$textWidth_u24lambda_u245.measureText(text);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static final float textHeight(@Nullable Paint $this$textHeight) {
        float f;
        Paint paint = $this$textHeight;
        if (paint != null) {
            Paint $this$textHeight_u24lambda_u246 = paint;
            boolean bl = false;
            f = $this$textHeight_u24lambda_u246.descent() - $this$textHeight_u24lambda_u246.ascent();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Nullable
    public static final View getChildOrNull(@NotNull View $this$getChildOrNull, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getChildOrNull, (String)"<this>");
        if ($this$getChildOrNull instanceof ViewGroup) {
            return (0 <= index ? index < ((ViewGroup)$this$getChildOrNull).getChildCount() : false) ? ((ViewGroup)$this$getChildOrNull).getChildAt(index) : null;
        }
        return $this$getChildOrNull;
    }

    @NotNull
    public static final Rect getLocationInParent(@NotNull View $this$getLocationInParent, @Nullable View parentView, @NotNull Rect result) {
        View parent;
        Intrinsics.checkNotNullParameter((Object)$this$getLocationInParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object object = parentView;
        if (object == null) {
            ViewParent viewParent = $this$getLocationInParent.getParent();
            object = viewParent instanceof View ? (View)viewParent : null;
        }
        if ((parent = object) == null) {
            LibExKt.getViewRect($this$getLocationInParent, result);
        } else {
            result.set(0, 0, 0, 0);
            if (!Intrinsics.areEqual((Object)$this$getLocationInParent, (Object)parent)) {
                LibExKt.getLocationInParent$doIt($this$getLocationInParent, parent, result);
            }
            result.right = result.left + $this$getLocationInParent.getMeasuredWidth();
            result.bottom = result.top + $this$getLocationInParent.getMeasuredHeight();
        }
        return result;
    }

    public static /* synthetic */ Rect getLocationInParent$default(View view, View view2, Rect rect, int n, Object object) {
        if ((n & 1) != 0) {
            view2 = null;
        }
        if ((n & 2) != 0) {
            rect = new Rect();
        }
        return LibExKt.getLocationInParent(view, view2, rect);
    }

    @NotNull
    public static final Rect getViewRect(@NotNull View $this$getViewRect, @NotNull Rect result) {
        int offsetY;
        int offsetX;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getViewRect, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            offsetX = 0;
            offsetY = 0;
            Context context = $this$getViewRect.getContext();
            Activity activity = context instanceof Activity ? (Activity)context : null;
            if (activity == null) break block1;
            Activity it = activity;
            boolean bl = false;
            it.getWindow().getDecorView().getGlobalVisibleRect(result);
            if (result.width() > result.height()) {
                offsetX = LibExKt.navBarHeight((Context)it);
            }
        }
        return LibExKt.getViewRect($this$getViewRect, offsetX, offsetY, result);
    }

    public static /* synthetic */ Rect getViewRect$default(View view, Rect rect, int n, Object object) {
        if ((n & 1) != 0) {
            rect = new Rect();
        }
        return LibExKt.getViewRect(view, rect);
    }

    @NotNull
    public static final Rect getViewRect(@NotNull View $this$getViewRect, int offsetX, int offsetY, @NotNull Rect result) {
        Intrinsics.checkNotNullParameter((Object)$this$getViewRect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int[] r2 = new int[2];
        $this$getViewRect.getLocationOnScreen(r2);
        int left = r2[0] + offsetX;
        int top = r2[1] + offsetY;
        result.set(left, top, left + $this$getViewRect.getMeasuredWidth(), top + $this$getViewRect.getMeasuredHeight());
        return result;
    }

    public static /* synthetic */ Rect getViewRect$default(View view, int n, int n2, Rect rect, int n3, Object object) {
        if ((n3 & 4) != 0) {
            rect = new Rect();
        }
        return LibExKt.getViewRect(view, n, n2, rect);
    }

    public static final int navBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        if (context instanceof Activity) {
            Rect decorRect = new Rect();
            Rect windowRect = new Rect();
            ((Activity)context).getWindow().getDecorView().getGlobalVisibleRect(decorRect);
            ((Activity)context).getWindow().findViewById(0x1020002).getGlobalVisibleRect(windowRect);
            result = decorRect.width() > decorRect.height() ? decorRect.width() - windowRect.width() : decorRect.bottom - windowRect.bottom;
        }
        return result;
    }

    public static final int size(@Nullable Collection<?> $this$size) {
        Collection<?> collection = $this$size;
        return collection != null ? collection.size() : 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> boolean isChange(@Nullable List<? extends T> $this$isChange, @Nullable List<? extends T> other) {
        block3: {
            if (LibExKt.size((Collection)$this$isChange) != LibExKt.size((Collection)other)) {
                return true;
            }
            List<? extends T> list = $this$isChange;
            if (list == null) break block3;
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void t;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t2 = item$iv;
                int index = n;
                boolean bl = false;
                List<? extends T> list2 = other;
                if (Intrinsics.areEqual((Object)t, (Object)(list2 != null ? CollectionsKt.getOrNull(list2, (int)index) : null))) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isHorizontal(int $this$isHorizontal) {
        return $this$isHorizontal == 0;
    }

    public static final boolean isVertical(int $this$isVertical) {
        return $this$isVertical == 1;
    }

    @NotNull
    public static final View inflate(@NotNull ViewGroup $this$inflate, @LayoutRes int layoutId, boolean attachToRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$inflate, (String)"<this>");
        if (layoutId == -1) {
            return (View)$this$inflate;
        }
        View rootView = LayoutInflater.from((Context)$this$inflate.getContext()).inflate(layoutId, $this$inflate, false);
        if (attachToRoot) {
            $this$inflate.addView(rootView);
        }
        Intrinsics.checkNotNullExpressionValue((Object)rootView, (String)"rootView");
        return rootView;
    }

    public static /* synthetic */ View inflate$default(ViewGroup viewGroup, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return LibExKt.inflate(viewGroup, n, bl);
    }

    private static final void getLocationInParent$doIt(View view, View parent, Rect rect) {
        ViewParent viewParent = view.getParent();
        if (viewParent instanceof View) {
            rect.left += view.getLeft();
            rect.top += view.getTop();
            if (!Intrinsics.areEqual((Object)viewParent, (Object)parent)) {
                LibExKt.getLocationInParent$doIt((View)viewParent, parent, rect);
            }
        }
    }
}

