/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Vector;
import com.github.andrewoma.dexx.collection.VectorPointer;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractBuilder;
import org.jetbrains.annotations.NotNull;

class VectorBuilder<E>
extends AbstractBuilder<E, Vector<E>> {
    private final VectorPointer<E> pointer = new VectorPointer();
    int blockIndex = 0;
    int lo = 0;

    VectorBuilder() {
        this.pointer.display0 = new Object[32];
        this.pointer.depth = 1;
    }

    @NotNull
    public VectorBuilder<E> add(E elem) {
        if (this.lo >= this.pointer.display0.length) {
            int newBlockIndex = this.blockIndex + 32;
            this.pointer.gotoNextBlockStartWritable(newBlockIndex, this.blockIndex ^ newBlockIndex);
            this.blockIndex = newBlockIndex;
            this.lo = 0;
        }
        this.pointer.display0[this.lo] = elem;
        ++this.lo;
        return this;
    }

    @Override
    @NotNull
    public Vector<E> build() {
        int size = this.blockIndex + this.lo;
        if (size == 0) {
            return Vector.empty();
        }
        Vector s = new Vector(0, size, 0);
        s.pointer.initFrom(this.pointer);
        if (this.pointer.depth > 1) {
            s.pointer.gotoPos(0, size - 1);
        }
        return s;
    }
}

