/*
 * Decompiled with CFR 0.152.
 */
package com.andremion.floatingnavigationview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Property;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.MenuRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.os.ParcelableCompat;
import androidx.core.os.ParcelableCompatCreatorCallbacks;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.view.AbsSavedState;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import com.andremion.floatingnavigationview.CircularRevealNavigationView;
import com.andremion.floatingnavigationview.R;
import com.google.android.material.circularreveal.CircularRevealCompat;
import com.google.android.material.circularreveal.CircularRevealWidget;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.internal.NavigationMenuView;
import com.google.android.material.navigation.NavigationView;

public class FloatingNavigationView
extends FloatingActionButton {
    private final WindowManager mWindowManager;
    private final CircularRevealNavigationView mNavigationView;
    private final NavigationMenuView mNavigationMenuView;
    private final ImageView mFabView;
    private final Rect mFabRect = new Rect();
    private final Rect mNavigationRect = new Rect();
    private final boolean mDrawMenuBelowFab;
    private final View.OnTouchListener mNavigationTouchListener = new View.OnTouchListener(){

        public boolean onTouch(@NonNull View v, @NonNull MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && (x < 0 || x >= FloatingNavigationView.this.mNavigationView.getWidth() || y < 0 || y >= FloatingNavigationView.this.mNavigationView.getHeight())) {
                FloatingNavigationView.this.close();
                return true;
            }
            if (MotionEventCompat.getActionMasked((MotionEvent)event) == 4) {
                FloatingNavigationView.this.close();
                return true;
            }
            return false;
        }
    };
    private final View.OnClickListener mFabClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            FloatingNavigationView.this.close();
        }
    };

    public FloatingNavigationView(Context context) {
        this(context, null);
    }

    public FloatingNavigationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatingNavigationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        this.setImageResource(R.drawable.ic_menu_vector);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mNavigationView = new CircularRevealNavigationView(context, attrs, defStyleAttr);
        this.setupNavigationView(context, attrs);
        this.mNavigationMenuView = (NavigationMenuView)this.mNavigationView.findViewById(R.id.design_navigation_view);
        this.mFabView = new ImageView(context, attrs, defStyleAttr);
        this.setupFabView(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FloatingNavigationView);
        this.mDrawMenuBelowFab = a.getBoolean(R.styleable.FloatingNavigationView_drawMenuBelowFab, false);
        a.recycle();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setupNavigationView(Context context, AttributeSet attrs) {
        this.mNavigationView.setBackground((Drawable)new ColorDrawable(this.getBackgroundColor()));
        this.mNavigationView.setOnTouchListener(this.mNavigationTouchListener);
    }

    @SuppressLint(value={"PrivateResource"})
    private void setupFabView(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{R.attr.selectableItemBackgroundBorderless});
        this.mFabView.setScaleType(ImageView.ScaleType.CENTER);
        this.mFabView.setBackground(a.getDrawable(0));
        this.mFabView.setOnClickListener(this.mFabClickListener);
        this.mFabView.setContentDescription(this.getContentDescription());
        this.mFabView.bringToFront();
        a.recycle();
        this.mNavigationView.addView((View)this.mFabView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.getResources().getDimensionPixelSize(R.dimen.design_fab_size_normal), this.getResources().getDimensionPixelSize(R.dimen.design_fab_size_normal)));
    }

    @ColorInt
    private int getBackgroundColor() {
        ColorStateList colorStateList = this.getBackgroundTintList();
        if (colorStateList != null) {
            return colorStateList.getDefaultColor();
        }
        Drawable background = this.getBackground();
        if (background instanceof ColorDrawable) {
            return ((ColorDrawable)background).getColor();
        }
        return this.getSolidColor();
    }

    public void setBackgroundTintList(@Nullable ColorStateList tint) {
        super.setBackgroundTintList(tint);
        ViewCompat.setBackgroundTintList((View)this.mNavigationView, (ColorStateList)tint);
    }

    @NonNull
    private static WindowManager.LayoutParams createLayoutParams(int gravity) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(-2, -1, 1000, 262408, -3);
        layoutParams.gravity = gravity;
        return layoutParams;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.detachNavigationView();
    }

    public void open() {
        if (this.isOpened()) {
            return;
        }
        this.attachNavigationView();
        this.mNavigationMenuView.scrollToPosition(0);
        this.mNavigationView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                FloatingNavigationView.this.mNavigationView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                FloatingNavigationView.this.updateFabBounds();
                FloatingNavigationView.this.drawMenuBelowFab();
                FloatingNavigationView.this.startOpenAnimations();
            }
        });
    }

    public void close() {
        if (!this.isOpened()) {
            return;
        }
        this.startCloseAnimations();
    }

    public boolean isOpened() {
        return this.mNavigationView.getParent() != null;
    }

    private void attachNavigationView() {
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)this.getLayoutParams();
        int gravity = 3;
        if (layoutParams.getAnchorId() != -1 && layoutParams.anchorGravity != 0) {
            if (Gravity.isHorizontal((int)layoutParams.anchorGravity)) {
                gravity = layoutParams.anchorGravity;
            }
        } else if (layoutParams.gravity != 0 && Gravity.isHorizontal((int)layoutParams.gravity)) {
            gravity = layoutParams.gravity;
        }
        gravity = Gravity.getAbsoluteGravity((int)gravity, (int)ViewCompat.getLayoutDirection((View)this));
        this.mWindowManager.addView((View)this.mNavigationView, (ViewGroup.LayoutParams)FloatingNavigationView.createLayoutParams(gravity));
    }

    private void detachNavigationView() {
        if (this.isOpened()) {
            this.mWindowManager.removeViewImmediate((View)this.mNavigationView);
        }
    }

    private void startOpenAnimations() {
        AnimatedVectorDrawableCompat menuIcon = AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)R.drawable.ic_menu_animated);
        this.mFabView.setImageDrawable((Drawable)menuIcon);
        menuIcon.start();
        int centerX = this.mFabRect.centerX();
        int centerY = this.mFabRect.centerY();
        float startRadius = this.getMinRadius();
        float endRadius = this.getMaxRadius();
        Animator reveal = CircularRevealCompat.createCircularReveal((CircularRevealWidget)this.mNavigationView, (float)centerX, (float)centerY, (float)startRadius, (float)endRadius);
        this.mNavigationMenuView.setAlpha(0.0f);
        ObjectAnimator fade = ObjectAnimator.ofFloat((Object)this.mNavigationMenuView, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(new Animator[]{reveal, fade});
        set.start();
    }

    private void startCloseAnimations() {
        AnimatedVectorDrawableCompat closeIcon = AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)R.drawable.ic_close_animated);
        this.mFabView.setImageDrawable((Drawable)closeIcon);
        closeIcon.start();
        int centerX = this.mFabRect.centerX();
        int centerY = this.mFabRect.centerY();
        float startRadius = this.getMaxRadius();
        float endRadius = this.getMinRadius();
        Animator reveal = CircularRevealCompat.createCircularReveal((CircularRevealWidget)this.mNavigationView, (float)centerX, (float)centerY, (float)startRadius, (float)endRadius);
        reveal.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingNavigationView.this.detachNavigationView();
            }
        });
        ObjectAnimator fade = ObjectAnimator.ofFloat((Object)this.mNavigationMenuView, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{fade, reveal});
        set.start();
    }

    private void updateFabBounds() {
        this.updateFabRect();
        this.updateNavigationRect();
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mFabView.getLayoutParams();
        layoutParams.width = this.getWidth();
        layoutParams.height = this.getHeight();
        layoutParams.topMargin = this.mFabRect.top;
        if (ViewCompat.getLayoutDirection((View)this) == 1) {
            layoutParams.rightMargin = this.mNavigationView.getWidth() - this.mFabRect.right;
        } else {
            layoutParams.leftMargin = this.mFabRect.left;
        }
        this.mFabView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void updateFabRect() {
        this.getGlobalVisibleRect(this.mFabRect);
        int[] offset = new int[2];
        this.mNavigationView.getLocationOnScreen(offset);
        this.mFabRect.offset(-offset[0], -offset[1]);
    }

    private void updateNavigationRect() {
        this.mNavigationView.getGlobalVisibleRect(this.mNavigationRect);
    }

    private void drawMenuBelowFab() {
        if (this.mDrawMenuBelowFab) {
            this.mNavigationMenuView.setPadding(this.mNavigationMenuView.getPaddingLeft(), this.mFabRect.bottom, this.mNavigationMenuView.getPaddingRight(), this.mNavigationMenuView.getPaddingBottom());
        }
    }

    private float getMinRadius() {
        return (float)this.mFabRect.width() / 2.0f;
    }

    private float getMaxRadius() {
        return (float)Math.hypot(this.mNavigationRect.width(), this.mNavigationRect.height());
    }

    public void setNavigationItemSelectedListener(@Nullable NavigationView.OnNavigationItemSelectedListener listener) {
        this.mNavigationView.setNavigationItemSelectedListener(listener);
    }

    public void inflateMenu(@MenuRes int resId) {
        this.mNavigationView.inflateMenu(resId);
    }

    public Menu getMenu() {
        return this.mNavigationView.getMenu();
    }

    public View inflateHeaderView(@LayoutRes int res) {
        return this.mNavigationView.inflateHeaderView(res);
    }

    public void addHeaderView(@NonNull View view) {
        this.mNavigationView.addHeaderView(view);
    }

    public void removeHeaderView(@NonNull View view) {
        this.mNavigationView.removeHeaderView(view);
    }

    public int getHeaderCount() {
        return this.mNavigationView.getHeaderCount();
    }

    public View getHeaderView(int index) {
        return this.mNavigationView.getHeaderView(index);
    }

    public void setCheckedItem(@IdRes int id2) {
        this.mNavigationView.setCheckedItem(id2);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.navigationViewState = new SparseArray();
        this.mNavigationView.saveHierarchyState(ss.navigationViewState);
        ss.opened = this.isOpened();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mNavigationView.restoreHierarchyState(ss.navigationViewState);
        if (ss.opened) {
            this.mFabView.setImageResource(R.drawable.ic_close_vector);
            this.post(new Runnable(){

                @Override
                public void run() {
                    FloatingNavigationView.this.attachNavigationView();
                    FloatingNavigationView.this.mNavigationView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                        public void onGlobalLayout() {
                            FloatingNavigationView.this.mNavigationView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            FloatingNavigationView.this.updateFabBounds();
                            FloatingNavigationView.this.drawMenuBelowFab();
                        }
                    });
                }
            });
        }
    }

    public static class SavedState
    extends AbsSavedState {
        private SparseArray navigationViewState;
        private boolean opened;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            public SavedState createFromParcel(Parcel parcel, ClassLoader loader) {
                return new SavedState(parcel, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        private SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.navigationViewState = in.readSparseArray(loader);
            this.opened = (Boolean)in.readValue(loader);
        }

        private SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeSparseArray(this.navigationViewState);
            dest.writeValue((Object)this.opened);
        }

        public String toString() {
            return FloatingNavigationView.class.getSimpleName() + "." + SavedState.class.getSimpleName() + "{" + Integer.toHexString(System.identityHashCode((Object)this)) + " opened=" + this.opened + "}";
        }
    }
}

