/*
 * Decompiled with CFR 0.152.
 */
package com.andremion.counterfab;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.core.graphics.ColorUtils;
import androidx.core.os.BundleKt;
import androidx.core.view.ViewCompat;
import com.andremion.counterfab.CounterFab;
import com.andremion.counterfab.CounterFabKt;
import com.andremion.counterfab.R;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.stateful.ExtendableSavedState;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\r\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020(J\b\u0010*\u001a\u00020\u0007H\u0002J\u0006\u0010+\u001a\u00020(J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007H\u0014J\u0012\u00102\u001a\u00020(2\b\u00103\u001a\u0004\u0018\u000104H\u0014J\n\u00105\u001a\u0004\u0018\u000104H\u0014J\b\u00106\u001a\u00020(H\u0002J\b\u00107\u001a\u00020(H\u0002J\f\u00108\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0014\u0010\"\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!R\u000e\u0010#\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/andremion/counterfab/CounterFab;", "Lcom/google/android/material/floatingactionbutton/FloatingActionButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animationDuration", "animationFactor", "", "animationProperty", "com/andremion/counterfab/CounterFab$animationProperty$1", "Lcom/andremion/counterfab/CounterFab$animationProperty$1;", "animator", "Landroid/animation/ObjectAnimator;", "badgePosition", "circleBounds", "Landroid/graphics/Rect;", "circlePaint", "Landroid/graphics/Paint;", "contentBounds", "value", "count", "getCount", "()I", "setCount", "(I)V", "countText", "", "isAnimating", "", "()Z", "isSizeMini", "textBounds", "textPadding", "textPaint", "textSize", "calculateCircleBounds", "", "decrease", "getDefaultBadgeColor", "increase", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "startAnimation", "updateCountText", "applyColorMask", "counterfab_release"})
public final class CounterFab
extends FloatingActionButton {
    private final animationProperty.1 animationProperty;
    private final float textSize;
    private final float textPadding;
    private final Paint circlePaint;
    private final Paint textPaint;
    private final Rect textBounds;
    private final Rect circleBounds;
    private final Rect contentBounds;
    private final int animationDuration;
    private float animationFactor;
    private ObjectAnimator animator;
    private final int badgePosition;
    private String countText;
    private int count;
    private HashMap _$_findViewCache;

    private final boolean isAnimating() {
        return this.animator.isRunning();
    }

    private final boolean isSizeMini() {
        return this.getSize() == 1;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(@IntRange(from=0L) int value) {
        if (value == this.count) {
            return;
        }
        this.count = value > 0 ? value : 0;
        this.updateCountText();
        if (ViewCompat.isLaidOut((View)((View)this))) {
            this.startAnimation();
        }
    }

    private final void updateCountText() {
        this.countText = this.isSizeMini() ? (this.count > 9 ? "9+" : String.valueOf(this.count)) : (this.count > 99 ? "99+" : String.valueOf(this.count));
    }

    private final int getDefaultBadgeColor() {
        Drawable background;
        CounterFab counterFab = this;
        CounterFab counterFab2 = this;
        CounterFab $receiver = counterFab;
        boolean bl = false;
        ColorStateList colorStateList = $receiver.getBackgroundTintList();
        int n = colorStateList != null ? colorStateList.getDefaultColor() : ((background = $receiver.getBackground()) instanceof ColorDrawable ? ((ColorDrawable)background).getColor() : $receiver.circlePaint.getColor());
        int n2 = n;
        return counterFab2.applyColorMask(n2);
    }

    private final int applyColorMask(int $receiver) {
        return ColorUtils.compositeColors((int)CounterFabKt.access$getMASK_COLOR$p(), (int)$receiver);
    }

    public final void increase() {
        CounterFab counterFab = this;
        counterFab.setCount(counterFab.count + 1);
    }

    public final void decrease() {
        this.setCount(this.count > 0 ? this.count - 1 : 0);
    }

    private final void startAnimation() {
        ObjectAnimator objectAnimator;
        float start = 0.0f;
        float end = 1.0f;
        if (this.count == 0) {
            start = 1.0f;
            end = 0.0f;
        }
        if (this.isAnimating()) {
            this.animator.cancel();
        }
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofObject((Object)((Object)this), (Property)this.animationProperty, null, (Object[])new Float[]{Float.valueOf(start), Float.valueOf(end)});
        CounterFab counterFab = this;
        ObjectAnimator $receiver = objectAnimator2;
        boolean bl = false;
        $receiver.setInterpolator((TimeInterpolator)CounterFabKt.access$getANIMATION_INTERPOLATOR$p());
        $receiver.setDuration((long)this.animationDuration);
        $receiver.start();
        ObjectAnimator objectAnimator3 = objectAnimator = objectAnimator2;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator3, (String)"ObjectAnimator.ofObject(\u2026        start()\n        }");
        counterFab.animator = objectAnimator3;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.calculateCircleBounds();
    }

    private final void calculateCircleBounds() {
        int circleStart;
        int n = this.textBounds.width();
        int n2 = this.textBounds.height();
        float circleRadius = (float)Math.max(n, n2) / 2.0f + this.textPadding;
        int circleEnd = (int)(circleRadius * (float)2);
        if (this.isSizeMini()) {
            circleStart = (int)(circleRadius / (float)2);
            this.circleBounds.set(circleStart, circleStart, circleEnd, circleEnd);
        } else {
            circleStart = 0;
            this.circleBounds.set(circleStart, circleStart, (int)(circleRadius * (float)2), (int)(circleRadius * (float)2));
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.count > 0 || this.isAnimating()) {
            if (this.getContentRect(this.contentBounds)) {
                int newLeft = 0;
                int newTop = 0;
                switch (this.badgePosition) {
                    case 1: {
                        newLeft = this.contentBounds.left;
                        newTop = this.contentBounds.bottom - this.circleBounds.height();
                        break;
                    }
                    case 2: {
                        newLeft = this.contentBounds.left;
                        newTop = this.contentBounds.top;
                        break;
                    }
                    case 3: {
                        newLeft = this.contentBounds.left + this.contentBounds.width() - this.circleBounds.width();
                        newTop = this.contentBounds.bottom - this.circleBounds.height();
                        break;
                    }
                    case 0: {
                        newLeft = this.contentBounds.left + this.contentBounds.width() - this.circleBounds.width();
                        newTop = this.contentBounds.top;
                        break;
                    }
                    default: {
                        newLeft = this.contentBounds.left + this.contentBounds.width() - this.circleBounds.width();
                        newTop = this.contentBounds.top;
                    }
                }
                this.circleBounds.offsetTo(newLeft, newTop);
            }
            float cx = this.circleBounds.centerX();
            float cy = this.circleBounds.centerY();
            float radius = (float)this.circleBounds.width() / 2.0f * this.animationFactor;
            canvas.drawCircle(cx, cy, radius, this.circlePaint);
            this.textPaint.setTextSize(this.textSize * this.animationFactor);
            canvas.drawText(this.countText, cx, cy + (float)this.textBounds.height() / 2.0f, this.textPaint);
        }
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (superState instanceof ExtendableSavedState) {
            ((ExtendableSavedState)superState).extendableStates.put((Object)CounterFabKt.access$getSTATE_KEY$p(), (Object)BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)"COUNT", (Object)this.count)}));
        }
        return superState;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Bundle bundle;
        super.onRestoreInstanceState(state);
        if (!(state instanceof ExtendableSavedState)) {
            return;
        }
        Bundle bundle2 = bundle = (Bundle)((ExtendableSavedState)state).extendableStates.get((Object)CounterFabKt.access$getSTATE_KEY$p());
        this.setCount(bundle2 != null ? bundle2.getInt("COUNT") : 0);
        this.requestLayout();
    }

    @JvmOverloads
    public CounterFab(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.animationProperty = new Property<CounterFab, Float>(this, Float.TYPE, "animation"){
            final /* synthetic */ CounterFab this$0;

            public void set(@NotNull CounterFab counterFab, float value) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)counterFab), (String)"counterFab");
                CounterFab.access$setAnimationFactor$p(this.this$0, value);
                this.this$0.postInvalidateOnAnimation();
            }

            @NotNull
            public Float get(@NotNull CounterFab counterFab) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)counterFab), (String)"counterFab");
                return Float.valueOf(0.0f);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        float f = 11;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.textSize = f * resources.getDisplayMetrics().density;
        float f2 = 2;
        Resources resources2 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        this.textPadding = f2 * resources2.getDisplayMetrics().density;
        Object object = new Paint(1);
        CounterFab counterFab = this;
        Object $receiver = object;
        boolean bl = false;
        $receiver.setStyle(Paint.Style.FILL);
        counterFab.circlePaint = paint = object;
        object = new Paint(1);
        counterFab = this;
        $receiver = object;
        boolean bl2 = false;
        $receiver.setStyle(Paint.Style.FILL_AND_STROKE);
        $receiver.setTextSize(this.textSize);
        $receiver.setTextAlign(Paint.Align.CENTER);
        $receiver.setTypeface(Typeface.SANS_SERIF);
        counterFab.textPaint = paint = object;
        object = this;
        counterFab = this;
        $receiver = (CounterFab)((Object)object);
        boolean bl3 = false;
        String maxCountText = "99+";
        Rect textBounds = new Rect();
        $receiver.textPaint.getTextBounds(maxCountText, 0, maxCountText.length(), textBounds);
        paint = textBounds;
        counterFab.textBounds = paint;
        this.circleBounds = new Rect();
        this.contentBounds = new Rect();
        this.animationDuration = this.getResources().getInteger(0x10E0000);
        this.animationFactor = 1.0f;
        this.animator = new ObjectAnimator();
        this.countText = "";
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CounterFab, 0, 0);
        this.textPaint.setColor(styledAttributes.getColor(R.styleable.CounterFab_badgeTextColor, -1));
        this.circlePaint.setColor(styledAttributes.getColor(R.styleable.CounterFab_badgeBackgroundColor, this.getDefaultBadgeColor()));
        this.badgePosition = styledAttributes.getInt(R.styleable.CounterFab_badgePosition, 0);
        styledAttributes.recycle();
        this.updateCountText();
    }

    @JvmOverloads
    public /* synthetic */ CounterFab(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.floatingActionButtonStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CounterFab(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CounterFab(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getAnimationFactor$p(CounterFab $this) {
        return $this.animationFactor;
    }

    public static final /* synthetic */ void access$setAnimationFactor$p(CounterFab $this, float f) {
        $this.animationFactor = f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

