/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.plugins.gif;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.harmony.x.imageio.plugins.ImageSignature;
import org.apache.harmony.x.imageio.plugins.ImageType;
import org.apache.harmony.x.imageio.plugins.gif.GIFImageReader;

public class GIFImageReaderSpi
extends ImageReaderSpi {
    public GIFImageReaderSpi() {
        super("Apache Harmony", "1.0", ImageType.GIF.getNames(), ImageType.GIF.getSuffixes(), ImageType.GIF.getMimeTypes(), GIFImageReader.class.getName(), STANDARD_INPUT_TYPE, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        byte[] sig = ImageSignature.readSignature(source, 6);
        return ImageSignature.GIF87a.verify(sig) || ImageSignature.GIF89a.verify(sig);
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new GIFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "GIF image decoder";
    }
}

