/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.plugins;

import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public enum ImageSignature {
    JPEG(new byte[]{-1, -40, -1}),
    BMP(new byte[]{66, 77}),
    GIF87a(new byte[]{71, 73, 70, 56, 55, 97}),
    GIF89a(new byte[]{71, 73, 70, 56, 57, 97}),
    PNG(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10});

    private final byte[] sig;

    private ImageSignature(byte[] sig) {
        this.sig = sig;
    }

    public static byte[] readSignature(Object source, int len) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.2", "source"));
        }
        if (!(source instanceof ImageInputStream)) {
            return null;
        }
        ImageInputStream iis = (ImageInputStream)source;
        byte[] sig = new byte[len];
        iis.mark();
        iis.readFully(sig);
        iis.reset();
        return sig;
    }

    public byte[] getBytes() {
        return (byte[])this.sig.clone();
    }

    public boolean verify(byte[] sig) {
        return Arrays.equals(this.sig, sig);
    }

    public boolean verify(Object source) throws IOException {
        return this.verify(ImageSignature.readSignature(source, this.sig.length));
    }
}

