/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.render;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import org.apache.harmony.awt.gl.MultiRectArea;
import org.apache.harmony.awt.internal.nls.Messages;

public class JavaShapeRasterizer {
    static final int POINT_CAPACITY = 16;
    int edgesCount;
    int edgeCur;
    int[] edgesX;
    int[] edgesY;
    int[] edgesYS;
    int[] edgesN;
    int[] edgesDY;
    int[] bounds;
    int boundCount;
    boolean[] edgesExt;
    int activeCount;
    float[] activeX;
    int[] activeYEnd;
    float[] activeXStep;
    int[] activeDY;
    boolean[] activeExt;
    int[] crossX;
    int[] crossDY;
    Filler filler;

    int[] checkBufSize(int[] buf, int size) {
        if (size == buf.length) {
            int[] tmp = new int[size + 16];
            System.arraycopy(buf, 0, tmp, 0, buf.length);
            buf = tmp;
        }
        return buf;
    }

    void addEdge(int x, int y, int num) {
        this.edgesX = this.checkBufSize(this.edgesX, this.edgesCount);
        this.edgesY = this.checkBufSize(this.edgesY, this.edgesCount);
        this.edgesN = this.checkBufSize(this.edgesN, this.edgesCount);
        this.edgesX[this.edgesCount] = x;
        this.edgesY[this.edgesCount] = y;
        this.edgesN[this.edgesCount] = num << 16 | this.edgesCount;
        ++this.edgesCount;
    }

    void makeBuffer(PathIterator path, double flatness) {
        this.edgesX = new int[16];
        this.edgesY = new int[16];
        this.edgesN = new int[16];
        this.bounds = new int[16];
        this.boundCount = 0;
        this.edgesCount = 0;
        this.filler = path.getWindingRule() == 0 ? new Filler.EvenOdd() : new Filler.NonZero();
        float[] coords = new float[2];
        boolean closed = true;
        while (!path.isDone()) {
            switch (path.currentSegment(coords)) {
                case 0: {
                    if (!closed) {
                        ++this.boundCount;
                        this.bounds = this.checkBufSize(this.bounds, this.boundCount);
                        this.bounds[this.boundCount] = this.edgesCount;
                    }
                    this.addEdge((int)coords[0], (int)coords[1], this.boundCount);
                    closed = false;
                    break;
                }
                case 1: {
                    this.addEdge((int)coords[0], (int)coords[1], this.boundCount);
                    break;
                }
                case 4: {
                    ++this.boundCount;
                    this.bounds = this.checkBufSize(this.bounds, this.boundCount);
                    this.bounds[this.boundCount] = this.edgesCount;
                    closed = true;
                    break;
                }
                default: {
                    throw new RuntimeException(Messages.getString("awt.36"));
                }
            }
            path.next();
        }
        if (!closed) {
            ++this.boundCount;
            this.bounds = this.checkBufSize(this.bounds, this.boundCount);
            this.bounds[this.boundCount] = this.edgesCount;
        }
    }

    void sort(int[] master, int[] slave, int length) {
        for (int i = 0; i < length - 1; ++i) {
            int num = i;
            int min = master[num];
            for (int j = i + 1; j < length; ++j) {
                if (master[j] >= min) continue;
                num = j;
                min = master[num];
            }
            if (num == i) continue;
            master[num] = master[i];
            master[i] = min;
            min = slave[num];
            slave[num] = slave[i];
            slave[i] = min;
        }
    }

    int getNext(int cur) {
        int n = this.edgesN[cur];
        int num = (n & 0xFFFF) + 1;
        int bound = n >> 16;
        if (num == this.bounds[bound + 1]) {
            return this.bounds[bound];
        }
        return num;
    }

    int getPrev(int cur) {
        int n = this.edgesN[cur];
        int num = (n & 0xFFFF) - 1;
        int bound = n >> 16;
        if (num < this.bounds[bound]) {
            return this.bounds[bound + 1] - 1;
        }
        return num;
    }

    int getNextShape(int cur) {
        int bound = this.edgesN[cur] >> 16;
        return this.bounds[bound + 1];
    }

    void init() {
        this.edgesYS = new int[this.edgesCount];
        System.arraycopy(this.edgesY, 0, this.edgesYS, 0, this.edgesCount);
        this.edgesDY = new int[this.edgesCount];
        for (int i = 0; i < this.edgesCount; ++i) {
            int dy;
            this.edgesDY[i] = dy = this.edgesY[this.getNext(i)] - this.edgesY[i];
        }
        this.edgesExt = new boolean[this.edgesCount];
        int prev = -1;
        int i = 0;
        int pos = 0;
        block1: while (i < this.edgesCount) {
            while (this.edgesDY[i] <= 0) {
                if ((i = this.getNext(i)) != pos) continue;
                i = pos = this.getNextShape(i);
                continue block1;
            }
            while (this.edgesDY[i] >= 0) {
                if (this.edgesDY[i] > 0) {
                    prev = i;
                }
                if ((i = this.getNext(i)) != pos) continue;
                i = pos = this.getNextShape(i);
                continue block1;
            }
            if (prev != -1) {
                this.edgesExt[prev] = true;
            }
            this.edgesExt[i] = true;
        }
        this.sort(this.edgesYS, this.edgesN, this.edgesCount);
        this.edgeCur = 0;
        this.activeCount = 0;
        this.activeX = new float[this.edgesCount];
        this.activeYEnd = new int[this.edgesCount];
        this.activeXStep = new float[this.edgesCount];
        this.activeDY = new int[this.edgesCount];
        this.activeExt = new boolean[this.edgesCount];
        this.crossX = new int[this.edgesCount];
        this.crossDY = new int[this.edgesCount];
    }

    void addActiveEdge(int levelY, int start, int end, boolean back) {
        int dy;
        int n = dy = back ? -this.edgesDY[end] : this.edgesDY[start];
        if (dy <= 0) {
            return;
        }
        int x1 = this.edgesX[start];
        int dx = this.edgesX[end] - x1;
        this.activeX[this.activeCount] = x1;
        this.activeYEnd[this.activeCount] = this.edgesY[end];
        this.activeXStep[this.activeCount] = (float)dx / (float)dy;
        this.activeDY[this.activeCount] = back ? -dy : dy;
        this.activeExt[this.activeCount] = back ? this.edgesExt[end] : this.edgesExt[start];
        ++this.activeCount;
    }

    int findActiveEdges(int levelY) {
        int edgeActive;
        for (edgeActive = this.edgeCur; edgeActive < this.edgesCount && this.edgesYS[edgeActive] == levelY; ++edgeActive) {
        }
        int activeNext = edgeActive;
        while (edgeActive > this.edgeCur) {
            int num = this.edgesN[--edgeActive] & 0xFFFF;
            this.addActiveEdge(levelY, num, this.getPrev(edgeActive), true);
            this.addActiveEdge(levelY, num, this.getNext(edgeActive), false);
        }
        this.edgeCur = activeNext;
        if (activeNext == this.edgesCount) {
            return this.edgesY[this.edgesCount - 1];
        }
        return this.edgesYS[activeNext];
    }

    public MultiRectArea rasterize(Shape shape, double flatness) {
        int y;
        PathIterator path = shape.getPathIterator(null, flatness);
        if (path.isDone()) {
            return new MultiRectArea();
        }
        this.makeBuffer(path, flatness);
        this.init();
        int nextY = y = this.edgesYS[0];
        MultiRectArea.LineCash rect = new MultiRectArea.LineCash(this.edgesCount);
        rect.setLine(y);
        while (y <= nextY) {
            int i;
            int crossCount = 0;
            if (y == nextY) {
                i = this.activeCount;
                while (i > 0) {
                    if (this.activeYEnd[--i] != y) continue;
                    --this.activeCount;
                    int length = this.activeCount - i;
                    if (length == 0) continue;
                    int pos = i + 1;
                    System.arraycopy(this.activeX, pos, this.activeX, i, length);
                    System.arraycopy(this.activeYEnd, pos, this.activeYEnd, i, length);
                    System.arraycopy(this.activeXStep, pos, this.activeXStep, i, length);
                    System.arraycopy(this.activeDY, pos, this.activeDY, i, length);
                    System.arraycopy(this.activeExt, pos, this.activeExt, i, length);
                }
                nextY = this.findActiveEdges(y);
            }
            for (i = 0; i < this.activeCount; ++i) {
                this.crossX[crossCount] = (int)Math.ceil(this.activeX[i]);
                this.crossDY[crossCount] = this.activeDY[i];
                ++crossCount;
            }
            if (crossCount == 0) {
                rect.skipLine();
            } else {
                this.sort(this.crossX, this.crossDY, crossCount);
                this.filler.add(rect, this.crossX, this.crossDY, crossCount, y);
            }
            for (i = 0; i < this.activeCount; ++i) {
                int n = i;
                this.activeX[n] = this.activeX[n] + this.activeXStep[i];
            }
            ++y;
        }
        return rect;
    }

    static abstract class Filler {
        Filler() {
        }

        abstract void add(MultiRectArea.LineCash var1, int[] var2, int[] var3, int var4, int var5);

        static int excludeEmpty(int[] points, int length) {
            int i = 0;
            while (i < length) {
                if (points[i] <= points[i + 1]) {
                    i += 2;
                    continue;
                }
                System.arraycopy(points, i + 2, points, i, (length -= 2) - i);
            }
            return length;
        }

        static int union(int[] points, int length) {
            int i = 1;
            while (i < length - 1) {
                if (points[i] < points[i - 1]) {
                    System.arraycopy(points, i + 1, points, i - 1, length - i - 1);
                    length -= 2;
                    continue;
                }
                if (points[i] >= points[i + 1] - 1) {
                    System.arraycopy(points, i + 2, points, i, length - i - 2);
                    length -= 2;
                    continue;
                }
                i += 2;
            }
            return length;
        }

        static class EvenOdd
        extends Filler {
            EvenOdd() {
            }

            @Override
            void add(MultiRectArea.LineCash rect, int[] points, int[] orient, int length, int y) {
                for (int i = 1; i < length; i += 2) {
                    int n = i;
                    points[n] = points[n] - 1;
                }
                length = EvenOdd.excludeEmpty(points, length);
                length = EvenOdd.union(points, length);
                rect.addLine(points, length);
            }
        }

        static class NonZero
        extends Filler {
            NonZero() {
            }

            @Override
            void add(MultiRectArea.LineCash rect, int[] points, int[] orient, int length, int y) {
                int i;
                int[] dst = new int[length];
                int dstLength = 1;
                dst[0] = points[0];
                int count = 0;
                boolean inside = true;
                for (i = 0; i < length; ++i) {
                    if ((count += orient[i] > 0 ? 1 : -1) == 0) {
                        dst[dstLength++] = points[i];
                        inside = false;
                        continue;
                    }
                    if (inside) continue;
                    dst[dstLength++] = points[i];
                    inside = true;
                }
                for (i = 1; i < dstLength; i += 2) {
                    int n = i;
                    dst[n] = dst[n] - 1;
                }
                dstLength = NonZero.excludeEmpty(dst, dstLength);
                dstLength = NonZero.union(dst, dstLength);
                rect.addLine(dst, dstLength);
            }
        }
    }
}

