/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.harmony.awt.gl.image.DecodingImageSource;

public class ImageLoader
extends Thread {
    ImageLoader() {
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createLoader() {
        final ImageLoadersStorage storage = ImageLoadersStorage.getStorage();
        List<Thread> list = storage.loaders;
        synchronized (list) {
            if (storage.loaders.size() < 5) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ImageLoader loader = new ImageLoader();
                        storage.loaders.add(loader);
                        loader.start();
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImageSource(DecodingImageSource imgSrc) {
        ImageLoadersStorage storage = ImageLoadersStorage.getStorage();
        List<DecodingImageSource> list = storage.queue;
        synchronized (list) {
            if (!storage.queue.contains(imgSrc)) {
                storage.queue.add(imgSrc);
            }
            if (storage.freeLoaders == 0) {
                ImageLoader.createLoader();
            }
            storage.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DecodingImageSource getWaitingImageSource() {
        ImageLoadersStorage storage = ImageLoadersStorage.getStorage();
        List<DecodingImageSource> list = storage.queue;
        synchronized (list) {
            DecodingImageSource isrc = null;
            if (storage.queue.size() == 0) {
                try {
                    storage.freeLoaders++;
                    storage.queue.wait(4000L);
                }
                catch (InterruptedException e) {
                    DecodingImageSource decodingImageSource = null;
                    return decodingImageSource;
                }
                finally {
                    storage.freeLoaders--;
                }
            }
            if (storage.queue.size() > 0) {
                isrc = storage.queue.get(0);
                storage.queue.remove(0);
            }
            return isrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            ImageLoadersStorage storage = ImageLoadersStorage.getStorage();
            block16: while (true) {
                try {
                    Object isrc;
                    while (storage.loaders.contains(this) && (isrc = ImageLoader.getWaitingImageSource()) != null) {
                        try {
                            ((DecodingImageSource)isrc).load();
                            continue block16;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break block18;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block18;
                }
            }
            finally {
                List<Thread> list = storage.loaders;
                synchronized (list) {
                    storage.loaders.remove(Thread.currentThread());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void beginAnimation() {
        ImageLoadersStorage storage = ImageLoadersStorage.getStorage();
        Thread currThread = Thread.currentThread();
        ImageLoadersStorage imageLoadersStorage = storage;
        synchronized (imageLoadersStorage) {
            storage.loaders.remove(currThread);
            if (storage.freeLoaders < storage.queue.size()) {
                ImageLoader.createLoader();
            }
        }
        currThread.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endAnimation() {
        ImageLoadersStorage storage = ImageLoadersStorage.getStorage();
        Thread currThread = Thread.currentThread();
        ImageLoadersStorage imageLoadersStorage = storage;
        synchronized (imageLoadersStorage) {
            if (storage.loaders.size() < 5 && !storage.loaders.contains(currThread)) {
                storage.loaders.add(currThread);
            }
        }
        currThread.setPriority(5);
    }

    static class ImageLoadersStorage {
        private static final int MAX_THREADS = 5;
        private static final int TIMEOUT = 4000;
        static ImageLoadersStorage instance;
        List<DecodingImageSource> queue = new LinkedList<DecodingImageSource>();
        List<Thread> loaders = new ArrayList<Thread>(5);
        private int freeLoaders;

        private ImageLoadersStorage() {
        }

        static ImageLoadersStorage getStorage() {
            if (instance == null) {
                instance = new ImageLoadersStorage();
            }
            return instance;
        }
    }
}

