/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.awt.gl.image.DecodingImageSource;
import org.apache.harmony.awt.gl.image.JpegDecoder;
import org.apache.harmony.awt.gl.image.PngDecoder;

abstract class ImageDecoder {
    private static final int MAX_BYTES_IN_SIGNATURE = 8;
    List<ImageConsumer> consumers;
    InputStream inputStream;
    DecodingImageSource src;
    boolean terminated;

    static ImageDecoder createDecoder(DecodingImageSource src, InputStream is) {
        InputStream markable = !is.markSupported() ? new BufferedInputStream(is) : is;
        try {
            markable.mark(8);
            byte[] signature = new byte[8];
            markable.read(signature, 0, 8);
            markable.reset();
            if ((signature[0] & 0xFF) == 255 && (signature[1] & 0xFF) == 216 && (signature[2] & 0xFF) == 255) {
                return new JpegDecoder(src, is);
            }
            if ((signature[0] & 0xFF) == 137 && (signature[1] & 0xFF) == 80 && (signature[2] & 0xFF) == 78 && (signature[3] & 0xFF) == 71 && (signature[4] & 0xFF) == 13 && (signature[5] & 0xFF) == 10 && (signature[6] & 0xFF) == 26 && (signature[7] & 0xFF) == 10) {
                return new PngDecoder(src, is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    ImageDecoder(DecodingImageSource _src, InputStream is) {
        this.src = _src;
        this.consumers = this.src.consumers;
        this.inputStream = is;
    }

    public abstract void decodeImage() throws IOException;

    public synchronized void closeStream() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void terminate() {
        this.src.lockDecoder(this);
        this.closeStream();
        this.terminated = true;
    }

    protected void setDimensions(int w, int h) {
        if (this.terminated) {
            return;
        }
        for (ImageConsumer ic : this.consumers) {
            ic.setDimensions(w, h);
        }
    }

    protected void setProperties(Hashtable<?, ?> props) {
        if (this.terminated) {
            return;
        }
        for (ImageConsumer ic : this.consumers) {
            ic.setProperties(props);
        }
    }

    protected void setColorModel(ColorModel cm) {
        if (this.terminated) {
            return;
        }
        for (ImageConsumer ic : this.consumers) {
            ic.setColorModel(cm);
        }
    }

    protected void setHints(int hints) {
        if (this.terminated) {
            return;
        }
        for (ImageConsumer ic : this.consumers) {
            ic.setHints(hints);
        }
    }

    protected void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pix, int off, int scansize) {
        if (this.terminated) {
            return;
        }
        this.src.lockDecoder(this);
        for (ImageConsumer ic : this.consumers) {
            ic.setPixels(x, y, w, h, model, pix, off, scansize);
        }
    }

    protected void setPixels(int x, int y, int w, int h, ColorModel model, int[] pix, int off, int scansize) {
        if (this.terminated) {
            return;
        }
        this.src.lockDecoder(this);
        for (ImageConsumer ic : this.consumers) {
            ic.setPixels(x, y, w, h, model, pix, off, scansize);
        }
    }

    protected void imageComplete(int status) {
        if (this.terminated) {
            return;
        }
        this.src.lockDecoder(this);
        ImageConsumer ic = null;
        Iterator<ImageConsumer> i = this.consumers.iterator();
        while (i.hasNext()) {
            try {
                ic = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.consumers.iterator();
                continue;
            }
            ic.imageComplete(status);
        }
    }
}

