/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.color.ColorScaler;
import org.apache.harmony.awt.gl.color.ICC_Transform;
import org.apache.harmony.awt.gl.color.NativeImageFormat;

public class ColorConverter {
    private ColorScaler scaler = new ColorScaler();

    public void loadScalingData(ColorSpace cs) {
        this.scaler.loadScalingData(cs);
    }

    public void translateColor(ICC_Transform t, BufferedImage src, BufferedImage dst) {
        boolean saveAlpha;
        NativeImageFormat srcIF = NativeImageFormat.createNativeImageFormat(src);
        NativeImageFormat dstIF = NativeImageFormat.createNativeImageFormat(dst);
        if (srcIF != null && dstIF != null) {
            t.translateColors(srcIF, dstIF);
            return;
        }
        srcIF = this.createImageFormat(src);
        dstIF = this.createImageFormat(dst);
        short[] srcChanData = (short[])srcIF.getChannelData();
        short[] dstChanData = (short[])dstIF.getChannelData();
        ColorModel srcCM = src.getColorModel();
        int nColorChannels = srcCM.getNumColorComponents();
        this.scaler.loadScalingData(srcCM.getColorSpace());
        ColorModel dstCM = dst.getColorModel();
        float[] alpha = null;
        boolean bl = saveAlpha = srcCM.hasAlpha() && dstCM.hasAlpha();
        if (saveAlpha) {
            alpha = new float[src.getWidth() * src.getHeight()];
        }
        WritableRaster wr = src.getRaster();
        int srcDataPos = 0;
        int alphaPos = 0;
        int nRows = srcIF.getNumRows();
        for (int row = 0; row < nRows; ++row) {
            int nCols = srcIF.getNumCols();
            for (int col = 0; col < nCols; ++col) {
                float[] normalizedVal = srcCM.getNormalizedComponents(wr.getDataElements(col, row, null), null, 0);
                if (saveAlpha) {
                    alpha[alphaPos++] = normalizedVal[nColorChannels];
                }
                this.scaler.scale(normalizedVal, srcChanData, srcDataPos);
                srcDataPos += nColorChannels;
            }
        }
        t.translateColors(srcIF, dstIF);
        nColorChannels = dstCM.getNumColorComponents();
        boolean fillAlpha = dstCM.hasAlpha();
        this.scaler.loadScalingData(dstCM.getColorSpace());
        float[] dstPixel = new float[dstCM.getNumComponents()];
        int dstDataPos = 0;
        alphaPos = 0;
        wr = dst.getRaster();
        int nRows2 = dstIF.getNumRows();
        for (int row = 0; row < nRows2; ++row) {
            int nCols = dstIF.getNumCols();
            for (int col = 0; col < nCols; ++col) {
                this.scaler.unscale(dstPixel, dstChanData, dstDataPos);
                dstDataPos += nColorChannels;
                if (fillAlpha) {
                    dstPixel[nColorChannels] = saveAlpha ? alpha[alphaPos++] : 1.0f;
                }
                wr.setDataElements(col, row, dstCM.getDataElements(dstPixel, 0, null));
            }
        }
    }

    public float[][] translateColor(ICC_Transform t, float[][] buffer, ColorSpace srcCS, ColorSpace dstCS, int nPixels) {
        int i;
        if (srcCS != null) {
            this.scaler.loadScalingData(srcCS);
        }
        int nSrcChannels = t.getNumInputChannels();
        short[] srcShortData = new short[nPixels * nSrcChannels];
        int srcDataPos = 0;
        for (int i2 = 0; i2 < nPixels; ++i2) {
            this.scaler.scale(buffer[i2], srcShortData, srcDataPos);
            srcDataPos += nSrcChannels;
        }
        short[] dstShortData = this.translateColor(t, srcShortData, null);
        int bufferSize = buffer[0].length;
        int nDstChannels = t.getNumOutputChannels();
        if (bufferSize < nDstChannels + 1) {
            for (i = 0; i < nPixels; ++i) {
                buffer[i] = new float[nDstChannels + 1];
            }
        }
        if (dstCS != null) {
            this.scaler.loadScalingData(dstCS);
        }
        int dstDataPos = 0;
        for (i = 0; i < nPixels; ++i) {
            this.scaler.unscale(buffer[i], dstShortData, dstDataPos);
            dstDataPos += nDstChannels;
        }
        return buffer;
    }

    public void translateColor(ICC_Transform t, Raster src, WritableRaster dst) {
        try {
            NativeImageFormat srcFmt = NativeImageFormat.createNativeImageFormat(src);
            NativeImageFormat dstFmt = NativeImageFormat.createNativeImageFormat(dst);
            if (srcFmt != null && dstFmt != null) {
                t.translateColors(srcFmt, dstFmt);
                return;
            }
        }
        catch (IllegalArgumentException srcFmt) {
            // empty catch block
        }
        this.scaler.loadScalingData(src, t.getSrc());
        short[] srcData = this.scaler.scale(src);
        short[] dstData = this.translateColor(t, srcData, null);
        this.scaler.loadScalingData(dst, t.getDst());
        this.scaler.unscale(dstData, dst);
    }

    public short[] translateColor(ICC_Transform t, short[] src, short[] dst) {
        NativeImageFormat srcFmt = this.createImageFormat(t, src, 0, true);
        NativeImageFormat dstFmt = this.createImageFormat(t, dst, srcFmt.getNumCols(), false);
        t.translateColors(srcFmt, dstFmt);
        return (short[])dstFmt.getChannelData();
    }

    private NativeImageFormat createImageFormat(BufferedImage bi) {
        int nRows = bi.getHeight();
        int nCols = bi.getWidth();
        int nComps = bi.getColorModel().getNumColorComponents();
        short[] imgData = new short[nRows * nCols * nComps];
        return new NativeImageFormat(imgData, nComps, nRows, nCols);
    }

    private NativeImageFormat createImageFormat(ICC_Transform t, short[] arr, int nCols, boolean in) {
        int nComponents;
        int n = nComponents = in ? t.getNumInputChannels() : t.getNumOutputChannels();
        if (arr == null || arr.length < nCols * nComponents) {
            arr = new short[nCols * nComponents];
        }
        if (nCols == 0) {
            nCols = arr.length / nComponents;
        }
        return new NativeImageFormat(arr, nComponents, 1, nCols);
    }
}

