/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

public class LUTTables {
    private static final byte[][] mulLUT = new byte[256][256];
    private static final byte[][] divLUT = new byte[256][256];

    private static void init_mulLUT() {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                LUTTables.mulLUT[i][j] = (byte)((double)((float)i * (float)j / 255.0f) + 0.5);
            }
        }
    }

    private static void init_divLUT() {
        for (int i = 1; i < 256; ++i) {
            int j;
            for (j = 0; j <= i; ++j) {
                LUTTables.divLUT[i][j] = (byte)((double)((float)j / (float)i * 255.0f) + 0.5);
            }
            while (j < 256) {
                LUTTables.divLUT[i][j] = 0;
                ++j;
            }
        }
    }

    public static byte MUL(int a, int b) {
        return mulLUT[a][b];
    }

    public static byte DIV(int a, int b) {
        return divLUT[a][b];
    }

    static {
        LUTTables.init_mulLUT();
        LUTTables.init_divLUT();
    }
}

