/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.harmony.awt.gl.font.FontManager;
import org.apache.harmony.awt.gl.image.BufferedImageGraphics2D;

public abstract class CommonGraphicsEnvironment
extends GraphicsEnvironment {
    @Override
    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        return new BufferedImageGraphics2D(bufferedImage);
    }

    @Override
    public String[] getAvailableFontFamilyNames(Locale locale) {
        Font[] fonts = this.getAllFonts();
        ArrayList<String> familyNames = new ArrayList<String>();
        for (Font element : fonts) {
            String name = element.getFamily(locale);
            if (familyNames.contains(name)) continue;
            familyNames.add(name);
        }
        return familyNames.toArray(new String[familyNames.size()]);
    }

    @Override
    public Font[] getAllFonts() {
        return FontManager.getInstance().getAllFonts();
    }

    @Override
    public String[] getAvailableFontFamilyNames() {
        return FontManager.getInstance().getAllFamilies();
    }

    public abstract GraphicsDevice getDefaultScreenDevice() throws HeadlessException;

    public abstract GraphicsDevice[] getScreenDevices() throws HeadlessException;
}

