/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.geom;

import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.awt.geom.GeometryUtil;
import org.apache.harmony.awt.geom.IntersectPoint;

public class CurveCrossingHelper {
    private double[][] coords;
    private int[][] rules;
    private int[] sizes;
    private int[] rulesSizes;
    private int[][] offsets;
    private List<IntersectPoint> isectPoints = new ArrayList<IntersectPoint>();

    public CurveCrossingHelper(double[][] coords, int[] sizes, int[][] rules, int[] rulesSizes, int[][] offsets) {
        this.coords = coords;
        this.rules = rules;
        this.sizes = sizes;
        this.rulesSizes = rulesSizes;
        this.offsets = offsets;
    }

    public IntersectPoint[] findCrossing() {
        double[] edge1 = new double[8];
        double[] edge2 = new double[8];
        double[] points = new double[6];
        double[] params = new double[6];
        double[] mp1 = new double[2];
        double[] cp1 = new double[2];
        double[] mp2 = new double[2];
        double[] cp2 = new double[2];
        int ipCount = 0;
        for (int i = 0; i < this.rulesSizes[0]; ++i) {
            int rule1 = this.rules[0][i];
            int endIndex1 = this.getCurrentEdge(0, i, edge1, mp1, cp1);
            for (int j = 0; j < this.rulesSizes[1]; ++j) {
                int k;
                ipCount = 0;
                int rule2 = this.rules[1][j];
                int endIndex2 = this.getCurrentEdge(1, j, edge2, mp2, cp2);
                if (!(rule1 != 1 && rule1 != 4 || rule2 != 1 && rule2 != 4)) {
                    ipCount = GeometryUtil.intersectLinesWithParams(edge1[0], edge1[1], edge1[2], edge1[3], edge2[0], edge2[1], edge2[2], edge2[3], params);
                    if (ipCount != 0) {
                        points[0] = GeometryUtil.line(params[0], edge1[0], edge1[2]);
                        points[1] = GeometryUtil.line(params[0], edge1[1], edge1[3]);
                    }
                } else if ((rule1 == 1 || rule1 == 4) && rule2 == 2) {
                    ipCount = GeometryUtil.intersectLineAndQuad(edge1[0], edge1[1], edge1[2], edge1[3], edge2[0], edge2[1], edge2[2], edge2[3], edge2[4], edge2[5], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.line(params[2 * k], edge1[0], edge1[2]);
                        points[2 * k + 1] = GeometryUtil.line(params[2 * k], edge1[1], edge1[3]);
                    }
                } else if (rule1 == 2 && (rule2 == 1 || rule2 == 4)) {
                    ipCount = GeometryUtil.intersectLineAndQuad(edge2[0], edge2[1], edge2[2], edge2[3], edge1[0], edge1[1], edge1[2], edge1[3], edge1[4], edge1[5], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.line(params[2 * k + 1], edge2[0], edge2[2]);
                        points[2 * k + 1] = GeometryUtil.line(params[2 * k + 1], edge2[1], edge2[3]);
                    }
                } else if (rule1 == 3 && (rule2 == 1 || rule2 == 4)) {
                    ipCount = GeometryUtil.intersectLineAndCubic(edge1[0], edge1[1], edge1[2], edge1[3], edge1[4], edge1[5], edge1[6], edge1[7], edge2[0], edge2[1], edge2[2], edge2[3], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.line(params[2 * k + 1], edge2[0], edge2[2]);
                        points[2 * k + 1] = GeometryUtil.line(params[2 * k + 1], edge2[1], edge2[3]);
                    }
                } else if ((rule1 == 1 || rule1 == 4) && rule2 == 3) {
                    ipCount = GeometryUtil.intersectLineAndCubic(edge1[0], edge1[1], edge1[2], edge1[3], edge2[0], edge2[1], edge2[2], edge2[3], edge2[4], edge2[5], edge2[6], edge2[7], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.line(params[2 * k], edge1[0], edge1[2]);
                        points[2 * k + 1] = GeometryUtil.line(params[2 * k], edge1[1], edge1[3]);
                    }
                } else if (rule1 == 2 && rule2 == 2) {
                    ipCount = GeometryUtil.intersectQuads(edge1[0], edge1[1], edge1[2], edge1[3], edge1[4], edge1[5], edge2[0], edge2[1], edge2[2], edge2[3], edge2[4], edge2[5], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.quad(params[2 * k], edge1[0], edge1[2], edge1[4]);
                        points[2 * k + 1] = GeometryUtil.quad(params[2 * k], edge1[1], edge1[3], edge1[5]);
                    }
                } else if (rule1 == 2 && rule2 == 3) {
                    ipCount = GeometryUtil.intersectQuadAndCubic(edge1[0], edge1[1], edge1[2], edge1[3], edge1[4], edge1[5], edge2[0], edge2[1], edge2[2], edge2[3], edge2[4], edge2[5], edge2[6], edge2[7], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.quad(params[2 * k], edge1[0], edge1[2], edge1[4]);
                        points[2 * k + 1] = GeometryUtil.quad(params[2 * k], edge1[1], edge1[3], edge1[5]);
                    }
                } else if (rule1 == 3 && rule2 == 2) {
                    ipCount = GeometryUtil.intersectQuadAndCubic(edge2[0], edge2[1], edge2[2], edge2[3], edge2[4], edge2[5], edge1[0], edge1[1], edge1[2], edge1[3], edge1[4], edge1[5], edge2[6], edge2[7], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.quad(params[2 * k + 1], edge2[0], edge2[2], edge2[4]);
                        points[2 * k + 1] = GeometryUtil.quad(params[2 * k + 1], edge2[1], edge2[3], edge2[5]);
                    }
                } else if (rule1 == 3 && rule2 == 3) {
                    ipCount = GeometryUtil.intersectCubics(edge1[0], edge1[1], edge1[2], edge1[3], edge1[4], edge1[5], edge1[6], edge1[7], edge2[0], edge2[1], edge2[2], edge2[3], edge2[4], edge2[5], edge2[6], edge2[7], params);
                    for (k = 0; k < ipCount; ++k) {
                        points[2 * k] = GeometryUtil.cubic(params[2 * k], edge1[0], edge1[2], edge1[4], edge1[6]);
                        points[2 * k + 1] = GeometryUtil.cubic(params[2 * k], edge1[1], edge1[3], edge1[5], edge1[7]);
                    }
                }
                endIndex1 = i;
                endIndex2 = j;
                int begIndex1 = i - 1;
                int begIndex2 = j - 1;
                for (int k2 = 0; k2 < ipCount; ++k2) {
                    IntersectPoint ip2 = null;
                    if (this.containsPoint(points[2 * k2], points[2 * k2 + 1])) continue;
                    for (IntersectPoint ip2 : this.isectPoints) {
                        if (begIndex1 == ip2.getBegIndex(true) && endIndex1 == ip2.getEndIndex(true)) {
                            if (ip2.getParam(true) > params[2 * k2]) {
                                endIndex1 = -(this.isectPoints.indexOf(ip2) + 1);
                                ip2.setBegIndex1(-(this.isectPoints.size() + 1));
                            } else {
                                begIndex1 = -(this.isectPoints.indexOf(ip2) + 1);
                                ip2.setEndIndex1(-(this.isectPoints.size() + 1));
                            }
                        }
                        if (begIndex2 != ip2.getBegIndex(false) || endIndex2 != ip2.getEndIndex(false)) continue;
                        if (ip2.getParam(false) > params[2 * k2 + 1]) {
                            endIndex2 = -(this.isectPoints.indexOf(ip2) + 1);
                            ip2.setBegIndex2(-(this.isectPoints.size() + 1));
                            continue;
                        }
                        begIndex2 = -(this.isectPoints.indexOf(ip2) + 1);
                        ip2.setEndIndex2(-(this.isectPoints.size() + 1));
                    }
                    if (rule1 == 4) {
                        rule1 = 1;
                    }
                    if (rule2 == 4) {
                        rule2 = 1;
                    }
                    this.isectPoints.add(new IntersectPoint(begIndex1, endIndex1, rule1, i, begIndex2, endIndex2, rule2, j, points[2 * k2], points[2 * k2 + 1], params[2 * k2], params[2 * k2 + 1]));
                }
            }
        }
        return this.isectPoints.toArray(new IntersectPoint[this.isectPoints.size()]);
    }

    private int getCurrentEdge(int areaIndex, int index, double[] c, double[] mp, double[] cp) {
        int endIndex = 0;
        switch (this.rules[areaIndex][index]) {
            case 0: {
                cp[0] = mp[0] = this.coords[areaIndex][this.offsets[areaIndex][index]];
                cp[1] = mp[1] = this.coords[areaIndex][this.offsets[areaIndex][index] + 1];
                break;
            }
            case 1: {
                c[0] = cp[0];
                c[1] = cp[1];
                cp[0] = c[2] = this.coords[areaIndex][this.offsets[areaIndex][index]];
                cp[1] = c[3] = this.coords[areaIndex][this.offsets[areaIndex][index] + 1];
                endIndex = 0;
                break;
            }
            case 2: {
                c[0] = cp[0];
                c[1] = cp[1];
                c[2] = this.coords[areaIndex][this.offsets[areaIndex][index]];
                c[3] = this.coords[areaIndex][this.offsets[areaIndex][index] + 1];
                cp[0] = c[4] = this.coords[areaIndex][this.offsets[areaIndex][index] + 2];
                cp[1] = c[5] = this.coords[areaIndex][this.offsets[areaIndex][index] + 3];
                endIndex = 2;
                break;
            }
            case 3: {
                c[0] = cp[0];
                c[1] = cp[1];
                c[2] = this.coords[areaIndex][this.offsets[areaIndex][index]];
                c[3] = this.coords[areaIndex][this.offsets[areaIndex][index] + 1];
                c[4] = this.coords[areaIndex][this.offsets[areaIndex][index] + 2];
                c[5] = this.coords[areaIndex][this.offsets[areaIndex][index] + 3];
                cp[0] = c[6] = this.coords[areaIndex][this.offsets[areaIndex][index] + 4];
                cp[1] = c[7] = this.coords[areaIndex][this.offsets[areaIndex][index] + 5];
                endIndex = 4;
                break;
            }
            case 4: {
                c[0] = cp[0];
                c[1] = cp[1];
                cp[0] = c[2] = mp[0];
                cp[1] = c[3] = mp[1];
                endIndex = this.offsets[areaIndex][index] >= this.sizes[areaIndex] ? -this.sizes[areaIndex] : 0;
            }
        }
        return this.offsets[areaIndex][index] + endIndex;
    }

    private boolean containsPoint(double x, double y) {
        for (IntersectPoint ipoint : this.isectPoints) {
            if (!(Math.abs(ipoint.getX() - x) < Math.pow(10.0, -6.0)) || !(Math.abs(ipoint.getY() - y) < Math.pow(10.0, -6.0))) continue;
            return true;
        }
        return false;
    }
}

